/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryDetailBillApplyInfoXbj4IncomeCalcService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoXbj4IncomeCalcReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO;
import com.tydic.fsc.settle.busi.api.bo.Xbj4IncomeCalcRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryDetailBillApplyInfoXbj4IncomeCalcServiceImpl
implements BusiQueryDetailBillApplyInfoXbj4IncomeCalcService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailBillApplyInfoXbj4IncomeCalcServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;

    public BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO queryEntryDetails(BusiQueryDetailBillApplyInfoXbj4IncomeCalcReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u7f34\u8d39\u6536\u5165\u8ba1\u7b97\u5355\u8be6\u60c5\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new BusinessException("1001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = null;
        if (applyNo.startsWith("KPSQ") && (billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo)) == null) {
            throw new BusinessException("1002", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        List<InquiryPayOrder> payOrderList = null;
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        BigDecimal applyAmt = BigDecimal.ZERO;
        InquiryPayOrderExt record = new InquiryPayOrderExt();
        if (applyNo.startsWith("KPSQ")) {
            record.setApplyNo(applyNo);
            payOrderList = this.inquiryPayOrderMapper.getListByPage(record, (Page<Map<String, Object>>)page);
        } else if (applyNo.startsWith("SRJS")) {
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setBillNo(applyNo);
            List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
            LinkedList<String> applyNoList = new LinkedList<String>();
            Iterator iterator = billApplyInfoList.iterator();
            while (iterator.hasNext()) {
                BillApplyInfo billApply = (BillApplyInfo)iterator.next();
                applyAmt = applyAmt.add(billApply.getAmt());
                applyNoList.add(billApply.getApplyNo());
            }
            if (!CollectionUtils.isEmpty(applyNoList)) {
                record.setApplyNoList(applyNoList);
                payOrderList = this.inquiryPayOrderMapper.getListByPage(record, (Page<Map<String, Object>>)page);
            }
        }
        ArrayList<Xbj4IncomeCalcRspBO> orderList = new ArrayList<Xbj4IncomeCalcRspBO>();
        if (!CollectionUtils.isEmpty(payOrderList)) {
            for (InquiryPayOrder inquiryPayOrder : payOrderList) {
                Xbj4IncomeCalcRspBO order = new Xbj4IncomeCalcRspBO();
                BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)order);
                String operUnitName = this.organizationInfoService.queryOrgName(inquiryPayOrder.getOperUnitNo());
                order.setOperUnitName(operUnitName);
                String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                order.setSupplierName(supplierName);
                order.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
                order.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
                order.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
                order.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
                order.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
                orderList.add(order);
            }
        }
        BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO rspBO = new BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO();
        if (applyNo.startsWith("KPSQ")) {
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
            rspBO.setSupplierName(billApplyInfo.getOperUnitName());
            rspBO.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(Integer.parseInt(billApplyInfo.getInvoiceType()))));
        } else if (applyNo.startsWith("SRJS")) {
            rspBO.setApplyNo(applyNo);
            WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
            workFlowDataInfo.setBillNo(applyNo);
            workFlowDataInfo = this.workFlowDataMapper.getModelBy(workFlowDataInfo);
            rspBO.setApplyDate(workFlowDataInfo.getApplyDate());
            rspBO.setAmt(applyAmt);
            rspBO.setSupplierName(this.organizationInfoService.queryOrgName(reqBO.getCompanyId()));
        }
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

