/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryDetailBillApplyInfoXbjService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoApplyXbjPlatfRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoApplyXbjTradeRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoInvoiceDetailXbjRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoInvoiceInfoXbjRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoInvoiceXbjRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailBillApplyInfoXbjReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayPlatfUseFeeRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceDetailMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.SaleInvoiceDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryDetailBillApplyInfoXbjServiceImpl
implements BusiQueryDetailBillApplyInfoXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailBillApplyInfoXbjServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;

    public BusiQueryDetailBillApplyInfoApplyXbjPlatfRspBO queryApplyForPlatfUseFee(BusiQueryDetailBillApplyInfoXbjReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u8be6\u60c5\u670d\u52a1(\u8be2\u6bd4\u4ef7)-\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u4fe1\u606f(\u5e73\u53f0\u4f7f\u7528\u8d39)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new BusinessException("1001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new BusinessException("1002", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        InquiryPayOrderExt record = new InquiryPayOrderExt();
        record.setApplyNo(applyNo);
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        int recordsTotal = 0;
        int total = 0;
        recordsTotal = this.inquiryPayOrderMapper.getCount(record);
        List<InquiryPayOrder> payOrderList = null;
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
            payOrderList = this.inquiryPayOrderMapper.getList(record);
        }
        ArrayList<PayPlatfUseFeeRspBO> orderList = null;
        if (payOrderList != null && !payOrderList.isEmpty()) {
            orderList = new ArrayList<PayPlatfUseFeeRspBO>();
            for (InquiryPayOrder inquiryPayOrder : payOrderList) {
                PayPlatfUseFeeRspBO order = new PayPlatfUseFeeRspBO();
                BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)order);
                String operUnitName = this.organizationInfoService.queryOrgName(inquiryPayOrder.getOperUnitNo());
                order.setOperUnitName(operUnitName);
                String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                order.setSupplierName(supplierName);
                order.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
                order.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
                order.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
                order.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
                order.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
                orderList.add(order);
            }
        } else {
            logger.info("\u5f00\u7968\u7533\u8bf7\uff1a" + applyNo + "\u6ca1\u6709\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f");
        }
        BusiQueryDetailBillApplyInfoApplyXbjPlatfRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyXbjPlatfRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(Integer.parseInt(billApplyInfo.getInvoiceType()))));
        rspBO.setOrderCount(Integer.valueOf(recordsTotal));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(total);
        rspBO.setPageNo(reqBO.getPageNo());
        return rspBO;
    }

    public BusiQueryDetailBillApplyInfoApplyXbjTradeRspBO queryApplyForTradeServiceFee(BusiQueryDetailBillApplyInfoXbjReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u8be6\u60c5\u670d\u52a1(\u8be2\u6bd4\u4ef7)-\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u4fe1\u606f(\u6210\u4ea4\u670d\u52a1\u8d39)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new BusinessException("1001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new BusinessException("1002", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        InquiryPayOrderExt record = new InquiryPayOrderExt();
        record.setApplyNo(applyNo);
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        int recordsTotal = 0;
        int total = 0;
        recordsTotal = this.inquiryPayOrderMapper.getCount(record);
        List<InquiryPayOrder> payOrderList = null;
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
            payOrderList = this.inquiryPayOrderMapper.getList(record);
        }
        ArrayList<PayTradeServiceFeeRspBO> orderList = null;
        if (payOrderList != null && !payOrderList.isEmpty()) {
            orderList = new ArrayList<PayTradeServiceFeeRspBO>();
            for (InquiryPayOrder inquiryPayOrder : payOrderList) {
                PayTradeServiceFeeRspBO order = new PayTradeServiceFeeRspBO();
                BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)order);
                if (inquiryPayOrder.getOperator() != null) {
                    String operatorName = this.userInfoService.queryUserNameByUserId(inquiryPayOrder.getOperator());
                    order.setOperatorName(operatorName);
                }
                String operUnitName = this.organizationInfoService.queryOrgName(inquiryPayOrder.getOperUnitNo());
                order.setOperUnitName(operUnitName);
                String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                order.setSupplierName(supplierName);
                order.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
                order.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
                order.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
                order.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
                order.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
                order.setPayFeeTypeDesc(this.enumsService.getDescr(InquiryPayFeeType.getInstance(inquiryPayOrder.getPayFeeType())));
                orderList.add(order);
            }
        } else {
            logger.info("\u5f00\u7968\u7533\u8bf7\uff1a" + applyNo + "\u6ca1\u6709\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f");
        }
        BusiQueryDetailBillApplyInfoApplyXbjTradeRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyXbjTradeRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(Integer.parseInt(billApplyInfo.getInvoiceType()))));
        rspBO.setOrderCount(Integer.valueOf(recordsTotal));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(total);
        rspBO.setPageNo(reqBO.getPageNo());
        return rspBO;
    }

    public BusiQueryDetailBillApplyInfoInvoiceXbjRspBO queryInvoice(BusiQueryDetailBillApplyInfoXbjReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u8be6\u60c5\u670d\u52a1(\u8be2\u6bd4\u4ef7)-\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new BusinessException("1001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new BusinessException("1002", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        BusiQueryDetailBillApplyInfoInvoiceXbjRspBO rspBO = new BusiQueryDetailBillApplyInfoInvoiceXbjRspBO();
        ArrayList<BusiQueryDetailBillApplyInfoInvoiceInfoXbjRspBO> rows = new ArrayList<BusiQueryDetailBillApplyInfoInvoiceInfoXbjRspBO>();
        rspBO.setRows(rows);
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(applyNo);
        Page page = new Page(reqBO.getPageNo(), 99999);
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectListPage(saleInvoiceInfoVO, (Page<Map<String, Object>>)page);
        rspBO.setIsExistsInvoice("1");
        if (saleInvoiceInfoList.isEmpty()) {
            rspBO.setIsExistsInvoice("0");
        }
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
            BusiQueryDetailBillApplyInfoInvoiceInfoXbjRspBO row = new BusiQueryDetailBillApplyInfoInvoiceInfoXbjRspBO();
            ArrayList<BusiQueryDetailBillApplyInfoInvoiceDetailXbjRspBO> invoiceDetails = new ArrayList<BusiQueryDetailBillApplyInfoInvoiceDetailXbjRspBO>();
            row.setInvoiceDetails(invoiceDetails);
            rows.add(row);
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            row.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
            row.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
            row.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
            row.setTaxAmt(saleInvoiceInfo.getTaxAmt());
            row.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
            row.setAmt(saleInvoiceInfo.getAmt());
            row.setInvoiceType(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
            row.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
            row.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
            row.setInvoiceUrl(FileUtils.obtainOSSUrl(saleInvoiceInfo.getElectronicInvoiceName()));
            row.setElectronicInvoiceName(saleInvoiceInfo.getElectronicInvoiceName());
            List<SaleInvoiceDetail> saleInvoiceDetailList = this.saleInvoiceDetailMapper.selectByInvoiceNo(saleInvoiceInfo.getInvoiceNo());
            for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetailList) {
                BusiQueryDetailBillApplyInfoInvoiceDetailXbjRspBO invoiceDetail = new BusiQueryDetailBillApplyInfoInvoiceDetailXbjRspBO();
                BeanUtils.copyProperties((Object)saleInvoiceDetail, (Object)invoiceDetail);
                invoiceDetail.setInspectionId(String.valueOf(saleInvoiceDetail.getInspectionId()));
                invoiceDetail.setItemNo(String.valueOf(saleInvoiceDetail.getItemNo()));
                invoiceDetails.add(invoiceDetail);
            }
        }
        return rspBO;
    }
}

