/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiQueryInspectionDetailUrlService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryInspectionDetailUrlReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryInspectionDetailUrlRspBO;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.enums.OrderSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryInspectionDetailUrlServiceImpl
implements BusiQueryInspectionDetailUrlService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryInspectionDetailUrlServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryInspectionDetailUrlRspBO query(BusiQueryInspectionDetailUrlReqBO reqBO) {
        Long inspectionId;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9a8c\u6536\u8be6\u60c5\u9875\u9762\u5730\u5740\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((inspectionId = reqBO.getInspectionId()) == null) {
            throw new BusinessException("1001", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReqType())) {
            throw new BusinessException("1001", "\u5165\u53c2reqType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderInfo saleOrder = new SaleOrderInfo();
        saleOrder.setInspectionId(inspectionId);
        saleOrder = this.saleOrderInfoMapper.getModelBy(saleOrder);
        if (saleOrder == null) {
            BusiQueryInspectionDetailUrlRspBO rspBO = new BusiQueryInspectionDetailUrlRspBO();
            rspBO.setUrl("");
            return rspBO;
        }
        String source = saleOrder.getSource();
        StringBuilder url = new StringBuilder();
        if (OrderSource.CONSULT_PRICE.getCode().equals(source) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source)) {
            url.append("/html/professionalCompany/order-saleOrder-wz-receiveSendGoods.html?saleOrderId=").append(saleOrder.getOrderId()).append("&purchaserId=").append(saleOrder.getPurchaseNo());
        } else if ("purOrder".equals(reqBO.getReqType())) {
            url.append("/html/supplier/receiveAndDeliverGoodsDetail.html?purchaseOrderId=").append(saleOrder.getPurchaseOrderId()).append("&purchaserId=").append(saleOrder.getPurchaseNo());
        } else {
            url.append("/html/professionalCompany/receiveAndDeliverGoodsDetail.html?id=").append(saleOrder.getOrderId()).append("&purchaserId=").append(saleOrder.getPurchaseNo()).append("&type=0");
        }
        BusiQueryInspectionDetailUrlRspBO rspBO = new BusiQueryInspectionDetailUrlRspBO();
        rspBO.setUrl(url.toString());
        return rspBO;
    }
}

