/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.MainAccountService;
import com.tydic.fsc.settle.busi.api.BusiQueryMainAcctService;
import com.tydic.fsc.settle.busi.api.bo.BusiLoadMainAcctRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryMainAcctReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryMainAcctRspBO;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQueryMainAcctServiceImpl
implements BusiQueryMainAcctService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryMainAcctServiceImpl.class);
    @Autowired
    private MainAccountService mainAccountService;
    @Autowired
    private EnumsService enumsService;

    public BusiQueryMainAcctRspBO queryMainAcct(BusiQueryMainAcctReqBO busiQueryMainAcctReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQueryMainAcctReqBO.toString());
        }
        MainAcctInfo mainAcctInfo = new MainAcctInfo();
        if (busiQueryMainAcctReqBO.getCompanyId() != null) {
            mainAcctInfo.setOrgId(busiQueryMainAcctReqBO.getCompanyId());
        }
        if (busiQueryMainAcctReqBO.getSource() != null) {
            mainAcctInfo.setSource(busiQueryMainAcctReqBO.getSource());
        }
        if (busiQueryMainAcctReqBO.getMainAcctNo() != null) {
            mainAcctInfo.setMainAcctNo(busiQueryMainAcctReqBO.getMainAcctNo());
        }
        BusiQueryMainAcctRspBO busiQueryMainAcctRspBO = new BusiQueryMainAcctRspBO();
        ArrayList<BusiLoadMainAcctRspBO> transList = new ArrayList<BusiLoadMainAcctRspBO>();
        List<MainAcctInfo> mainAcctList = this.mainAccountService.listAccount(mainAcctInfo);
        if (!mainAcctList.isEmpty()) {
            for (MainAcctInfo mainAcct : mainAcctList) {
                BusiLoadMainAcctRspBO busiLoadMainAcctRspBO = new BusiLoadMainAcctRspBO();
                busiLoadMainAcctRspBO.setCompanyId(mainAcct.getOrgId());
                busiLoadMainAcctRspBO.setMainAcctName(mainAcct.getMainAcctName());
                busiLoadMainAcctRspBO.setMainAcctNo(mainAcct.getMainAcctNo());
                busiLoadMainAcctRspBO.setSource(mainAcct.getSource());
                busiLoadMainAcctRspBO.setOpenBank(mainAcct.getOpenBank());
                if (mainAcct.getSource().equals(OrderSource.CONSULT_PRICE.getCode())) {
                    busiLoadMainAcctRspBO.setSourceDescr("\u8be2\u6bd4\u4ef7\u670d\u52a1\u8d39");
                } else if (mainAcct.getSource().equals(OrderSource.ELECTRIC_AREA.getCode())) {
                    busiLoadMainAcctRspBO.setSourceDescr("\u914d\u9001\u4e1a\u52a1\u8d27\u6b3e");
                } else {
                    busiLoadMainAcctRspBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)mainAcct.getSource())));
                }
                transList.add(busiLoadMainAcctRspBO);
            }
            busiQueryMainAcctRspBO.setMainAcctList(transList);
            return busiQueryMainAcctRspBO;
        }
        busiQueryMainAcctRspBO.setMainAcctList(transList);
        logger.error("\u4e3b\u8d26\u53f7:" + busiQueryMainAcctReqBO.getMainAcctNo() + "\u4e0d\u5b58\u5728\uff01");
        return busiQueryMainAcctRspBO;
    }
}

