/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryRecAmtConfirmService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryRecAmtConfirmDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryRecAmtConfirmReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryRecAmtConfirmRspBO;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.vo.RecAmtConfirmPagination;
import com.tydic.fsc.settle.dao.vo.RecAmtConfirmVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.RecAmtConfirmStatus;
import com.tydic.fsc.settle.enums.ReceiptStatus;
import com.tydic.fsc.settle.enums.WFStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQueryRecAmtConfirmServiceImpl
implements BusiQueryRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryRecAmtConfirmServiceImpl.class);
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;

    public BusiQueryRecAmtConfirmRspBO queryRecAmtConfirm(BusiQueryRecAmtConfirmReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new BusinessException("1001", "\u516c\u53f8ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecAmtConfirmPagination pagination = new RecAmtConfirmPagination();
        try {
            BeanUtils.copyProperties((Object)reqBO, (Object)pagination);
            pagination.setOrgId(reqBO.getCompanyId());
        }
        catch (Exception e) {
            throw new BusinessException("1002", "\u521d\u59cb\u5316\u5206\u9875\u67e5\u8be2\u7ec4\u4ef6\u51fa\u9519");
        }
        if (pagination.getCreateDateEnd() != null) {
            try {
                String createDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(pagination.getCreateDateEnd()) + " 23:59:59";
                pagination.setCreateDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(createDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("1002", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        pagination.setStatus(RecAmtConfirmStatus.VALID.getCode());
        pagination.setOrderBy("c.DOC_NUM desc");
        pagination.initPagination();
        int recordsTotal = this.recAmtConfirmMapper.selectCountByConditionExt(pagination);
        pagination.completePagination(recordsTotal);
        List<RecAmtConfirmVO> rows = this.recAmtConfirmMapper.selectByConditionExt(pagination);
        BusiQueryRecAmtConfirmRspBO rspBO = new BusiQueryRecAmtConfirmRspBO();
        BeanUtils.copyProperties((Object)pagination, (Object)rspBO);
        ArrayList<BusiQueryRecAmtConfirmDetailRspBO> detailRows = new ArrayList<BusiQueryRecAmtConfirmDetailRspBO>();
        for (RecAmtConfirmVO row : rows) {
            BusiQueryRecAmtConfirmDetailRspBO detail = new BusiQueryRecAmtConfirmDetailRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setDocNum(String.valueOf(row.getDocNum()));
            String orgName = this.organizationInfoService.queryOrgName(row.getOrgId());
            detail.setOrgName(orgName);
            detail.setStatusDescr(this.enumsService.getDescr(RecAmtConfirmStatus.getInstance(row.getStatus())));
            detail.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            if (StringUtils.isNotBlank((CharSequence)detail.getApprovalStatus())) {
                detail.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(detail.getApprovalStatus())));
            }
            detail.setLastOperator(this.userInfoService.queryUserNameByUserId(row.getLastOperator()));
            detail.setReceiptStatusDescr(this.enumsService.getDescr(ReceiptStatus.getInstance(row.getReceiptStatus())));
            detailRows.add(detail);
        }
        rspBO.setRows(detailRows);
        return rspBO;
    }
}

