/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiGetInvoiceService;
import com.tydic.fsc.settle.busi.api.BusiReGetInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiRegetInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiRegetInvoiceRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.BillNotificationInfoVO;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiReGetInvoiceServiceImpl
implements BusiReGetInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiReGetInvoiceServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired(required=false)
    private BusiGetInvoiceService busiGetInvoiceService;

    public BusiRegetInvoiceRspBO updateGetInvoice(BusiRegetInvoiceReqBO reqBo) {
        if (reqBo.getNotificationNos() == null || reqBo.getNotificationNos().isEmpty()) {
            throw new BusinessException("1001", "\u8bf7\u52fe\u9009");
        }
        List notificationNos = reqBo.getNotificationNos();
        int count = this.billNotificationInfoMapper.selectStatusCountByNos(notificationNos, NotificationInvoiceStatus.SUBMITED.getCode(), NotificationInvoiceStatus.HAS_MAKE.getCode());
        if (count > 0) {
            throw new BusinessException("1002", "\u5f00\u7968\u901a\u77e5\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4 \u3001\u5df2\u5f00\u7968 ");
        }
        this.payInvoiceInfoMapper.deleteByNotificationNos(notificationNos);
        BillNotificationInfoVO notification = new BillNotificationInfoVO();
        notification.setNotificationNos(notificationNos);
        notification.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        notification.setInvoiceResultNull("1");
        this.billNotificationInfoMapper.update(notification);
        for (String notificationNo : notificationNos) {
            PayPurchaseOrderInfo order = new PayPurchaseOrderInfo();
            order.setNotificationNo(notificationNo);
            order.setOrderStatus(OrderStatus.APPLIED.getCode());
            this.payPurchaseOrderInfoMapper.updateStatus(order);
            PayItemInfoVO item = new PayItemInfoVO();
            item.setNotificationNo(notificationNo);
            item.setItemStatus(OrderStatus.APPLIED.getCode());
            item.setInvoiceCodeNull("1");
            item.setInvoiceNoNull("1");
            this.payItemInfoMapper.update(item);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u91cd\u65b0\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff0c\u7ebf\u7a0b\u7761\u7720\u5f02\u5e38\u3002", (Throwable)e);
                }
                BusiGetInvoiceServiceReqBO reqBO = new BusiGetInvoiceServiceReqBO();
                BusiReGetInvoiceServiceImpl.this.busiGetInvoiceService.getInvoice(reqBO);
            }
        }).start();
        return new BusiRegetInvoiceRspBO();
    }
}

