/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnQryApplyService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnFileRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnInvoiceRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnQryApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnQryApplyRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.DzcsInvoiceReturnFileType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnQryApplyServiceImpl
implements DzcsInvoiceReturnQryApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnQryApplyServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public DzcsInvoiceReturnQryApplyRspBO query(DzcsInvoiceReturnQryApplyReqBO reqBO) {
        String billNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9000\u7968\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(billNo = reqBO.getBillNo()))) {
            throw new BusinessException("1001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        DzcsInvoiceReturnQryApplyRspBO rspBO = new DzcsInvoiceReturnQryApplyRspBO();
        String invoiceClasses = null;
        String invoiceType = null;
        BeanUtils.copyProperties((Object)invoiceReturn, (Object)rspBO);
        ArrayList<DzcsInvoiceReturnInvoiceRspBO> invoices = new ArrayList<DzcsInvoiceReturnInvoiceRspBO>();
        rspBO.setInvoices(invoices);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billNo);
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
        if (!invoiceReturnDetails.isEmpty()) {
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                String applyNo1 = invoiceReturnDetail.getApplyNo1();
                String invoiceNo = invoiceReturnDetail.getInvoiceNo1();
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                invoiceClasses = billApplyInfo.getInvoiceClasses();
                invoiceType = billApplyInfo.getInvoiceType();
                SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
                DzcsInvoiceReturnInvoiceRspBO invoice = new DzcsInvoiceReturnInvoiceRspBO();
                invoices.add(invoice);
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                invoice.setMatchFlag("1");
                invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                invoice.setAmt(saleInvoiceInfo.getAmt());
                invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                invoice.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId()));
            }
        } else {
            List<String> applyNo1s = com.tydic.fsc.settle.utils.StringUtils.string2List(invoiceReturn.getApplyNo1(), ",");
            for (String applyNo1 : applyNo1s) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                invoiceClasses = billApplyInfo.getInvoiceClasses();
                invoiceType = billApplyInfo.getInvoiceType();
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo1);
                List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                    DzcsInvoiceReturnInvoiceRspBO invoice = new DzcsInvoiceReturnInvoiceRspBO();
                    invoices.add(invoice);
                    BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                    invoice.setMatchFlag("0");
                    invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                    invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                    invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                    invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                    invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                    invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                    invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                    invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                    invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                    invoice.setAmt(saleInvoiceInfo.getAmt());
                    invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                    invoice.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId()));
                }
            }
        }
        rspBO.setInvoiceClasses(invoiceClasses);
        rspBO.setNoticeItem(this.enumsService.queryDzcsInvoiceReturnNoticeItem());
        ArrayList<DzcsInvoiceReturnFileRspBO> files = new ArrayList<DzcsInvoiceReturnFileRspBO>();
        rspBO.setFiles(files);
        if (InvoiceType.SPECIAL.getCode().toString().equals(invoiceType)) {
            DzcsInvoiceReturnFileRspBO dzcsInvoiceReturnFileRspBO = new DzcsInvoiceReturnFileRspBO();
            dzcsInvoiceReturnFileRspBO.setFileType(DzcsInvoiceReturnFileType.LICENSE_FILE.getCode());
            dzcsInvoiceReturnFileRspBO.setItemname(DzcsInvoiceReturnFileType.LICENSE_FILE.getDescr());
            String filename = invoiceReturn.getLicenseFile();
            String filenameUrl = invoiceReturn.obtainOSSUrl(filename);
            dzcsInvoiceReturnFileRspBO.setFilename(filename);
            dzcsInvoiceReturnFileRspBO.setFilenameUrl(filenameUrl);
            dzcsInvoiceReturnFileRspBO.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
            dzcsInvoiceReturnFileRspBO.setTemplateUrl("");
            dzcsInvoiceReturnFileRspBO.setShowTemplateUrl("0");
            dzcsInvoiceReturnFileRspBO.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
            dzcsInvoiceReturnFileRspBO.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
            files.add(dzcsInvoiceReturnFileRspBO);
            DzcsInvoiceReturnFileRspBO dzcsInvoiceReturnFileRspBO2 = new DzcsInvoiceReturnFileRspBO();
            dzcsInvoiceReturnFileRspBO2.setFileType(DzcsInvoiceReturnFileType.APPLY_FILE.getCode());
            dzcsInvoiceReturnFileRspBO2.setItemname(DzcsInvoiceReturnFileType.APPLY_FILE.getDescr());
            filename = invoiceReturn.getApplyFile();
            filenameUrl = invoiceReturn.obtainOSSUrl(filename);
            dzcsInvoiceReturnFileRspBO2.setFilename(filename);
            dzcsInvoiceReturnFileRspBO2.setFilenameUrl(filenameUrl);
            dzcsInvoiceReturnFileRspBO2.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
            dzcsInvoiceReturnFileRspBO2.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate1()));
            dzcsInvoiceReturnFileRspBO2.setShowTemplateUrl("1");
            dzcsInvoiceReturnFileRspBO2.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
            dzcsInvoiceReturnFileRspBO2.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
            files.add(dzcsInvoiceReturnFileRspBO2);
            DzcsInvoiceReturnFileRspBO dzcsInvoiceReturnFileRspBO3 = new DzcsInvoiceReturnFileRspBO();
            dzcsInvoiceReturnFileRspBO3.setFileType(DzcsInvoiceReturnFileType.REMARK_FILE.getCode());
            dzcsInvoiceReturnFileRspBO3.setItemname(DzcsInvoiceReturnFileType.REMARK_FILE.getDescr());
            filename = invoiceReturn.getRemarkFile();
            filenameUrl = invoiceReturn.obtainOSSUrl(filename);
            dzcsInvoiceReturnFileRspBO3.setFilename(filename);
            dzcsInvoiceReturnFileRspBO3.setFilenameUrl(filenameUrl);
            dzcsInvoiceReturnFileRspBO3.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
            dzcsInvoiceReturnFileRspBO3.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate2()));
            dzcsInvoiceReturnFileRspBO3.setShowTemplateUrl("1");
            dzcsInvoiceReturnFileRspBO3.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
            dzcsInvoiceReturnFileRspBO3.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
            files.add(dzcsInvoiceReturnFileRspBO3);
            DzcsInvoiceReturnFileRspBO dzcsInvoiceReturnFileRspBO4 = new DzcsInvoiceReturnFileRspBO();
            dzcsInvoiceReturnFileRspBO4.setFileType(DzcsInvoiceReturnFileType.RED_FILE.getCode());
            dzcsInvoiceReturnFileRspBO4.setItemname(DzcsInvoiceReturnFileType.RED_FILE.getDescr());
            filename = invoiceReturn.getRedFile();
            filenameUrl = invoiceReturn.obtainOSSUrl(filename);
            dzcsInvoiceReturnFileRspBO4.setFilename(filename);
            dzcsInvoiceReturnFileRspBO4.setFilenameUrl(filenameUrl);
            dzcsInvoiceReturnFileRspBO4.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
            dzcsInvoiceReturnFileRspBO4.setTemplateUrl("");
            dzcsInvoiceReturnFileRspBO4.setShowTemplateUrl("0");
            dzcsInvoiceReturnFileRspBO4.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
            dzcsInvoiceReturnFileRspBO4.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
            files.add(dzcsInvoiceReturnFileRspBO4);
            int index = DzcsInvoiceReturnFileType.INVOICE_FILE.getCode();
            String invoiceFile = invoiceReturn.getInvoiceFile();
            List<String> originalFilenames = com.tydic.fsc.settle.utils.StringUtils.string2List(invoiceFile, ",");
            for (String originalFilename : originalFilenames) {
                DzcsInvoiceReturnFileRspBO dzcsInvoiceReturnFileRspBO5 = new DzcsInvoiceReturnFileRspBO();
                dzcsInvoiceReturnFileRspBO5.setFileType(Integer.valueOf(index));
                dzcsInvoiceReturnFileRspBO5.setItemname(DzcsInvoiceReturnFileType.INVOICE_FILE.getDescr());
                dzcsInvoiceReturnFileRspBO5.setFilename(originalFilename);
                filenameUrl = invoiceReturn.obtainOSSUrl(originalFilename);
                dzcsInvoiceReturnFileRspBO5.setFilenameUrl(filenameUrl);
                dzcsInvoiceReturnFileRspBO5.setShowFilenameUrl(StringUtils.hasText((String)originalFilename) ? "1" : "0");
                dzcsInvoiceReturnFileRspBO5.setTemplateUrl("");
                dzcsInvoiceReturnFileRspBO5.setShowTemplateUrl("0");
                dzcsInvoiceReturnFileRspBO5.setShowUpload(StringUtils.hasText((String)originalFilename) ? "0" : "1");
                dzcsInvoiceReturnFileRspBO5.setShowDelete(StringUtils.hasText((String)originalFilename) ? "1" : "0");
                files.add(dzcsInvoiceReturnFileRspBO5);
                ++index;
            }
            DzcsInvoiceReturnFileRspBO dzcsInvoiceReturnFileRspBO6 = new DzcsInvoiceReturnFileRspBO();
            dzcsInvoiceReturnFileRspBO6.setFileType(Integer.valueOf(++index));
            dzcsInvoiceReturnFileRspBO6.setItemname(DzcsInvoiceReturnFileType.INVOICE_FILE.getDescr());
            dzcsInvoiceReturnFileRspBO6.setFilename("");
            dzcsInvoiceReturnFileRspBO6.setFilenameUrl("");
            dzcsInvoiceReturnFileRspBO6.setShowFilenameUrl("0");
            dzcsInvoiceReturnFileRspBO6.setTemplateUrl("");
            dzcsInvoiceReturnFileRspBO6.setShowTemplateUrl("0");
            dzcsInvoiceReturnFileRspBO6.setShowUpload("1");
            dzcsInvoiceReturnFileRspBO6.setShowDelete("0");
            files.add(dzcsInvoiceReturnFileRspBO6);
        }
        return rspBO;
    }
}

