/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.tydic.fsc.settle.busi.api.InsertPayInvoiceInfoBusiService;
import com.tydic.fsc.settle.busi.api.QueryBillNotificationInfoService;
import com.tydic.fsc.settle.busi.api.bo.InsertPayInvoiceInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.InsertPayInvoiceInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayInvoiceInfoBO;
import com.tydic.fsc.settle.busi.api.bo.QueryBillNotificationInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryBillNotificationInfoRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InsertPayInvoiceInfoBusiServiceImpl
implements InsertPayInvoiceInfoBusiService {
    private static final Logger logger = LoggerFactory.getLogger(InsertPayInvoiceInfoBusiServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private QueryBillNotificationInfoService queryBillNotificationInfoService;

    public InsertPayInvoiceInfoRspBO insert(InsertPayInvoiceInfoReqBO insertPayInvoiceInfoReqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a" + insertPayInvoiceInfoReqBO);
        }
        InsertPayInvoiceInfoRspBO rspBO = new InsertPayInvoiceInfoRspBO();
        List listReqBO = insertPayInvoiceInfoReqBO.getListReqBO();
        if (insertPayInvoiceInfoReqBO == null || listReqBO == null || listReqBO.size() == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.debug("\u5bfc\u5165\u7684\u53d1\u7968\u6570\u91cf:" + listReqBO.size());
        HashMap groupMap = new HashMap();
        for (PayInvoiceInfoBO payInvoiceInfoBO : listReqBO) {
            if (!groupMap.containsKey(payInvoiceInfoBO.getNotificationNo())) {
                LinkedList<PayInvoiceInfoBO> invoiceList = new LinkedList<PayInvoiceInfoBO>();
                invoiceList.add(payInvoiceInfoBO);
                groupMap.put(payInvoiceInfoBO.getNotificationNo(), invoiceList);
                continue;
            }
            ((List)groupMap.get(payInvoiceInfoBO.getNotificationNo())).add(payInvoiceInfoBO);
        }
        HashMap<String, String> invoiceValMap = new HashMap<String, String>();
        LinkedList allInvoiceList = new LinkedList();
        HashMap<String, Date> invoiceDateMap = new HashMap<String, Date>();
        for (Map.Entry entry : groupMap.entrySet()) {
            String notificationNo = (String)entry.getKey();
            BigDecimal sumAmt = BigDecimal.ZERO;
            BigDecimal sumNotTaxAmt = BigDecimal.ZERO;
            BigDecimal sumTaxAmt = BigDecimal.ZERO;
            for (PayInvoiceInfoBO payInvoiceInfo : (List)entry.getValue()) {
                sumAmt = sumAmt.add(payInvoiceInfo.getAmt());
                sumNotTaxAmt = sumNotTaxAmt.add(payInvoiceInfo.getNotTaxAmt());
                sumTaxAmt = sumTaxAmt.add(payInvoiceInfo.getTaxAmt());
            }
            logger.debug("\u4ef7\u7a0e\u5408\u8ba1=" + sumAmt + ",\u91d1\u989d(\u4e0d\u542b\u7a0e)=" + sumNotTaxAmt + ",\u7a0e\u989d=" + sumTaxAmt);
            if (sumAmt.compareTo(sumNotTaxAmt.add(sumTaxAmt)) != 0) {
                throw new BusinessException("8888", "\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0e\u7a0e\u989d\u4e4b\u548c!");
            }
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            if (null == billNotificationInfo) {
                throw new BusinessException("8888", "\u53d1\u7968\u901a\u77e5\u5355[" + notificationNo + "]\u4e0d\u5b58\u5728");
            }
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u7684\u91d1\u989d=" + billNotificationInfo.getAmt());
            int compareTo = billNotificationInfo.getAmt().compareTo(sumAmt);
            if (compareTo != 0) {
                throw new BusinessException("8888", "\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u53d1\u7968\u901a\u77e5\u5355\u7684\u91d1\u989d!");
            }
            logger.debug("\u6839\u636e\u5f00\u7968\u901a\u77e5\u5355\u53f7\u5220\u9664\u53d1\u7968\u4fe1\u606f\u8868\uff0c\u53ca\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8868\u5e76\u8fd4\u56de\u6570\u636e");
            QueryBillNotificationInfoReqBO reqBO = new QueryBillNotificationInfoReqBO();
            reqBO.setNotificationNo(notificationNo);
            QueryBillNotificationInfoRspBO deleteAndqueryBillNotifiInfo = this.queryBillNotificationInfoService.deleteAndqueryBillNotifiInfo(reqBO);
            if (!deleteAndqueryBillNotifiInfo.getRespCode().equals("0000")) {
                throw new BusinessException("8888", deleteAndqueryBillNotifiInfo.getRespDesc());
            }
            String allInvoice = "";
            Date invoiceDate = null;
            for (PayInvoiceInfoBO payInvoiceInfo : (List)entry.getValue()) {
                allInvoice = StringUtils.isEmpty((Object)allInvoice) ? payInvoiceInfo.getInvoiceNo() : allInvoice + "," + payInvoiceInfo.getInvoiceNo();
                payInvoiceInfo.setAddress(deleteAndqueryBillNotifiInfo.getAddr());
                payInvoiceInfo.setBankAcNo(deleteAndqueryBillNotifiInfo.getBankAccNo());
                payInvoiceInfo.setBankName(deleteAndqueryBillNotifiInfo.getBankName());
                payInvoiceInfo.setInvoiceStatus(deleteAndqueryBillNotifiInfo.getInvoiceStatus());
                payInvoiceInfo.setMailStatus("01");
                payInvoiceInfo.setPhone(deleteAndqueryBillNotifiInfo.getPhone());
                payInvoiceInfo.setName(deleteAndqueryBillNotifiInfo.getInvoceName());
                payInvoiceInfo.setTaxNo(deleteAndqueryBillNotifiInfo.getTaxNo());
                if (null == invoiceDate) {
                    invoiceDate = payInvoiceInfo.getInvoiceDate();
                    continue;
                }
                if (!invoiceDate.before(payInvoiceInfo.getInvoiceDate())) continue;
                invoiceDate = payInvoiceInfo.getInvoiceDate();
            }
            invoiceValMap.put(notificationNo, allInvoice);
            allInvoiceList.addAll((Collection)entry.getValue());
            invoiceDateMap.put(notificationNo, invoiceDate);
        }
        List list = BeanMapper.mapList(allInvoiceList, PayInvoiceInfo.class);
        this.payInvoiceInfoMapper.batchInsert(list);
        for (Map.Entry entry : groupMap.entrySet()) {
            String notificationNo = (String)entry.getKey();
            BillNotificationInfo record = new BillNotificationInfo();
            record.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            record.setNotificationNo(notificationNo);
            record.setInvoiceDate((Date)invoiceDateMap.get(notificationNo));
            int cnt = this.billNotificationInfoMapper.updateByPrimaryKeySelective(record);
            logger.debug("\u4fee\u6539\u901a\u77e5\u5355\u53f7\u7684\u72b6\u6001\u4e3a\u5df2\u5f00\u7968,\u901a\u77e5\u5355\u53f7=" + notificationNo + " \u66f4\u65b0\u6570=" + cnt);
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            cnt = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            logger.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt);
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            List payInvoiceInfoList = (List)entry.getValue();
            payItemUpd.setInvoiceCode(((PayInvoiceInfoBO)payInvoiceInfoList.get(0)).getInvoiceCode());
            payItemUpd.setInvoiceNo((String)invoiceValMap.get(notificationNo));
            this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
            logger.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u4e3a\u5df2\u6536\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u65b0\u589e\u6210\u529f");
        return rspBO;
    }
}

