/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.InvoiceReturnQryApplyService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnFileRspBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnInvoiceRspBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnQryApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnQryApplyRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnFileType;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnQryApplyServiceImpl
implements InvoiceReturnQryApplyService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnQryApplyServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    /*
     * WARNING - void declaration
     */
    public InvoiceReturnQryApplyRspBO query(InvoiceReturnQryApplyReqBO reqBO) {
        void var9_17;
        void var9_15;
        void var9_14;
        void var9_13;
        String billNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9000\u7968\u7533\u8bf7\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(billNo = reqBO.getBillNo()))) {
            throw new BusinessException("1001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        InvoiceReturnQryApplyRspBO rspBO = new InvoiceReturnQryApplyRspBO();
        BeanUtils.copyProperties((Object)invoiceReturn, (Object)rspBO);
        ArrayList<InvoiceReturnInvoiceRspBO> invoices = new ArrayList<InvoiceReturnInvoiceRspBO>();
        rspBO.setInvoices(invoices);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billNo);
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
        if (!invoiceReturnDetails.isEmpty()) {
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                String applyNo1 = invoiceReturnDetail.getApplyNo1();
                String invoiceNo = invoiceReturnDetail.getInvoiceNo1();
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
                InvoiceReturnInvoiceRspBO invoice = new InvoiceReturnInvoiceRspBO();
                invoices.add(invoice);
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                invoice.setMatchFlag("1");
                invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                invoice.setAmt(saleInvoiceInfo.getAmt());
                invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
            }
        } else {
            List<String> applyNo1s = com.tydic.fsc.settle.utils.StringUtils.string2List(invoiceReturn.getApplyNo1(), ",");
            for (String applyNo1 : applyNo1s) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo1);
                List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                    InvoiceReturnInvoiceRspBO invoice = new InvoiceReturnInvoiceRspBO();
                    invoices.add(invoice);
                    BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                    invoice.setMatchFlag("0");
                    invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                    invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                    invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                    invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                    invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                    invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                    invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                    invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                    invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                    invoice.setAmt(saleInvoiceInfo.getAmt());
                    invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                }
            }
        }
        ArrayList<InvoiceReturnFileRspBO> files = new ArrayList<InvoiceReturnFileRspBO>();
        rspBO.setFiles(files);
        int n = 1;
        InvoiceReturnFileRspBO file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf(n));
        file.setItemname(InvoiceReturnFileType.LICENSE_FILE.getDescr());
        String filename = invoiceReturn.getLicenseFile();
        String filenameUrl = invoiceReturn.obtainOSSUrl(filename);
        file.setFilename(filename);
        file.setFilenameUrl(filenameUrl);
        file.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
        file.setTemplateUrl("");
        file.setShowTemplateUrl("0");
        file.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
        file.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf((int)(++var9_13)));
        file.setItemname(InvoiceReturnFileType.BANK_LICENSE_FILE.getDescr());
        filename = invoiceReturn.getBankLicenseFile();
        filenameUrl = invoiceReturn.obtainOSSUrl(filename);
        file.setFilename(filename);
        file.setFilenameUrl(filenameUrl);
        file.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
        file.setTemplateUrl("");
        file.setShowTemplateUrl("0");
        file.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
        file.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf((int)(++var9_14)));
        file.setItemname(InvoiceReturnFileType.APPLY_FILE.getDescr());
        filename = invoiceReturn.getApplyFile();
        filenameUrl = invoiceReturn.obtainOSSUrl(filename);
        file.setFilename(filename);
        file.setFilenameUrl(filenameUrl);
        file.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
        file.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate1()));
        file.setShowTemplateUrl("1");
        file.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
        file.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf((int)(++var9_15)));
        file.setItemname(InvoiceReturnFileType.REMARK_FILE.getDescr());
        filename = invoiceReturn.getRemarkFile();
        filenameUrl = invoiceReturn.obtainOSSUrl(filename);
        file.setFilename(filename);
        file.setFilenameUrl(filenameUrl);
        file.setShowFilenameUrl(StringUtils.hasText((String)filename) ? "1" : "0");
        file.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate2()));
        file.setShowTemplateUrl("1");
        file.setShowUpload(StringUtils.hasText((String)filename) ? "0" : "1");
        file.setShowDelete(StringUtils.hasText((String)filename) ? "1" : "0");
        files.add(file);
        String invoiceFile = invoiceReturn.getInvoiceFile();
        List<String> originalFilenames = com.tydic.fsc.settle.utils.StringUtils.string2List(invoiceFile, ",");
        for (String originalFilename : originalFilenames) {
            void var9_16;
            file = new InvoiceReturnFileRspBO();
            file.setFileType(Integer.valueOf((int)(++var9_16)));
            file.setItemname(InvoiceReturnFileType.INVOICE_FILE.getDescr());
            file.setFilename(originalFilename);
            filenameUrl = invoiceReturn.obtainOSSUrl(originalFilename);
            file.setFilenameUrl(filenameUrl);
            file.setShowFilenameUrl(StringUtils.hasText((String)originalFilename) ? "1" : "0");
            file.setTemplateUrl("");
            file.setShowTemplateUrl("0");
            file.setShowUpload(StringUtils.hasText((String)originalFilename) ? "0" : "1");
            file.setShowDelete(StringUtils.hasText((String)originalFilename) ? "1" : "0");
            files.add(file);
        }
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf((int)(++var9_17)));
        file.setItemname(InvoiceReturnFileType.INVOICE_FILE.getDescr());
        file.setFilename("");
        file.setFilenameUrl("");
        file.setShowFilenameUrl("0");
        file.setTemplateUrl("");
        file.setShowTemplateUrl("0");
        file.setShowUpload("1");
        file.setShowDelete("0");
        files.add(file);
        return rspBO;
    }
}

