/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrderService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.bo.ReceiveDetailBO;
import com.tydic.fsc.settle.atom.bo.SaleOrderBO;
import com.tydic.fsc.settle.busi.api.QueryApplyPayInfoByIdService;
import com.tydic.fsc.settle.busi.api.bo.ApplyPayInfoBO;
import com.tydic.fsc.settle.busi.api.bo.QueryApplyPayInfoByIdReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryApplyPayInfoByIdRspBO;
import com.tydic.fsc.settle.busi.api.vo.ApplyDetailVO;
import com.tydic.fsc.settle.dao.ApplyDetailMapper;
import com.tydic.fsc.settle.dao.ApplyPayInfoMapper;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.po.ApplyDetail;
import com.tydic.fsc.settle.dao.po.ApplyPayInfoPO;
import com.tydic.fsc.settle.dao.po.PayableDetailPO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.PayResultStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryApplyPayInfoByIdServiceImpl
implements QueryApplyPayInfoByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryApplyPayInfoByIdServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private OrderService orderService;

    public QueryApplyPayInfoByIdRspBO queryById(QueryApplyPayInfoByIdReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        QueryApplyPayInfoByIdRspBO queryApplyPayInfoByIdRspBO = new QueryApplyPayInfoByIdRspBO();
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(reqBO.getId());
        if (applyPayInfoPO == null) {
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u4ed8\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
        BeanUtils.copyProperties((Object)applyPayInfoPO, (Object)applyPayInfoBO);
        PayResultStatus payResultEnum = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
        applyPayInfoBO.setPayStatusStr(payResultEnum.getDescr());
        OrderSource orderSourceEnum = OrderSource.getInstance((String)applyPayInfoBO.getSource());
        applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
        String supplierStr = this.organizationInfoService.querySupplierName(applyPayInfoBO.getSupplierId());
        applyPayInfoBO.setSupplierStr(supplierStr);
        applyPayInfoBO.setSupplierName(supplierStr);
        queryApplyPayInfoByIdRspBO.setApplyPayInfoBO(applyPayInfoBO);
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(reqBO.getId());
        if (applyDetails.isEmpty()) {
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        LinkedList<ApplyDetailVO> rows = new LinkedList<ApplyDetailVO>();
        for (ApplyDetail singleDetail : applyDetails) {
            PayableDetailPO singlePayable = this.payableDetailMapper.getModelById(singleDetail.getPayableNo());
            if (singlePayable == null) {
                throw new BusinessException("RSP_CODE_DATA_NULL", "\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            String payType = singlePayable.getPayType();
            ApplyDetailVO payableDetailBO = new ApplyDetailVO();
            BeanUtils.copyProperties((Object)singleDetail, (Object)payableDetailBO);
            BeanUtils.copyProperties((Object)singlePayable, (Object)payableDetailBO);
            PayResultStatus payResultStatus = PayResultStatus.getInstance(payableDetailBO.getStatus());
            payableDetailBO.setPayResultStatusStr(payResultStatus.getDescr());
            OrderSource orderSourceEnum2 = OrderSource.getInstance((String)payableDetailBO.getSource());
            payableDetailBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum2));
            String supplierStr2 = this.organizationInfoService.querySupplierName(payableDetailBO.getSupplierId());
            payableDetailBO.setSupplierStr(supplierStr2);
            String orgNameStr = this.organizationInfoService.queryOrgName(payableDetailBO.getOperatorId());
            payableDetailBO.setOperatorStr(orgNameStr);
            SaleOrderBO saleOrderBO = this.orderService.obtainSaleOrder(singlePayable.getOrderId());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setSource(singlePayable.getSource());
            saleOrderInfoVO.setOrderId(saleOrderBO.getSaleOrderId());
            saleOrderInfoVO.setSaleOrderCode(saleOrderBO.getSaleOrderCode());
            Map<String, ReceiveDetailBO> receiveDetail = this.orderService.obtainReceiveDetail(saleOrderInfoVO);
            payableDetailBO.setToReceiveAmt(receiveDetail.get(payType).getToReceiveAmt());
            payableDetailBO.setReceivedAmt(receiveDetail.get(payType).getReceivedAmt());
            payableDetailBO.setReceiveRemark(receiveDetail.get(payType).getReceiveRemark());
            rows.add(payableDetailBO);
        }
        queryApplyPayInfoByIdRspBO.setRows(rows);
        return queryApplyPayInfoByIdRspBO;
    }
}

