/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.BusiQueryBillApplyInfoDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDetailDlzqRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDlzqReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDlzqRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QueryInvoiceMailInfoServiceImpl
implements BusiQueryBillApplyInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(QueryInvoiceMailInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public BusiQueryBillApplyInfoDlzqRspBO query(BusiQueryBillApplyInfoDlzqReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u529b\u4e13\u533a)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("1001", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && reqBO.getPurchaseNo() == null) {
            throw new BusinessException("1001", "\u91c7\u8d2d\u5355\u4f4d\u3010purchaseNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoVO);
        billApplyInfoVO.setSource(OrderSource.ELECTRIC_AREA.getCode());
        billApplyInfoVO.setReturnBillNoIsNull("1");
        if ("1".equals(reqBO.getIsOperUnit())) {
            billApplyInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            try {
                String applyDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(billApplyInfoVO.getApplyDateEnd()) + " 23:59:59";
                billApplyInfoVO.setApplyDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(applyDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("1002", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        billApplyInfoVO.setOrderBy("t.APPLY_NO DESC");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryBillApplyInfoDetailDlzqRspBO> rows = new ArrayList<BusiQueryBillApplyInfoDetailDlzqRspBO>();
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiQueryBillApplyInfoDetailDlzqRspBO row = new BusiQueryBillApplyInfoDetailDlzqRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            row.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
            rows.add(row);
        }
        BusiQueryBillApplyInfoDlzqRspBO rspBO = new BusiQueryBillApplyInfoDlzqRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

