/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.busi.api.ReconciliationHisService;
import com.tydic.fsc.settle.busi.api.bo.ReconciliationReqBo;
import com.tydic.fsc.settle.busi.api.vo.ReconciliationDataBo;
import com.tydic.fsc.settle.busi.api.vo.ReconciliationHisVo;
import com.tydic.fsc.settle.busi.api.vo.ReconciliationRspVo;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.ReconcilitionHisMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.po.ReconcilitionHis;
import com.tydic.fsc.settle.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationHisServiceImpl
implements ReconciliationHisService {
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private Map<String, String> reconcilStatusMap = new HashMap<String, String>();
    private Map<String, String> orderStatusMap = new HashMap<String, String>();

    public ReconciliationRspVo getReceiptInfoBO(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, String> reconclStatusMap = this.getReconcilStatusMap();
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        Page page = new Page(condition.getPageNo(), condition.getPageSize());
        List<ReconcilitionHis> hisRows = this.reconcilitionHisMapper.getPageListByCondition(condition, (Page<Map<String, Object>>)page);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        for (ReconcilitionHis reconciliationHis : hisRows) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconciliationHis, (Object)vo);
            if (null != reconciliationHis.getOrderAmt()) {
                vo.setEorderAmt(reconciliationHis.getOrderAmt());
            }
            if (null != reconciliationHis.getOutAmt()) {
                vo.setOrderAmt(reconciliationHis.getOutAmt());
            }
            if (null != reconciliationHis.getOrderId()) {
                vo.setOrderId(reconciliationHis.getOrderId() + "");
            }
            if (null != reconciliationHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconciliationHis.getReconciliationStatus() + ""));
            }
            if (null != reconciliationHis.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(reconciliationHis.getOrderDate()));
            }
            if (null != reconciliationHis.getReconciliationDate()) {
                vo.setReconcilDate(DateUtil.dateToStr(reconciliationHis.getReconciliationDate()));
            }
            if (null != reconciliationHis.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(reconciliationHis.getRecvDate()));
            }
            if (null != reconciliationHis.getOrderId()) {
                Long orderId = reconciliationHis.getOrderId();
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setPurchaseOrderCode(orderId + "");
            }
            rows.add(vo);
        }
        ReconciliationDataBo data = new ReconciliationDataBo();
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRows(rows);
        rspVo.setData(data);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    public ReconciliationRspVo getHisExcel(ReconciliationReqBo condition) {
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ReconciliationDataBo data = new ReconciliationDataBo();
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, String> reconclStatusMap = this.getReconcilStatusMap();
        List<ReconcilitionHis> hisRows = this.reconcilitionHisMapper.getHisByCondition(condition);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        for (ReconcilitionHis reconciliationHis : hisRows) {
            if (reconciliationHis == null) continue;
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconciliationHis, (Object)vo);
            if (null != reconciliationHis.getOrderAmt()) {
                vo.setEorderAmt(reconciliationHis.getOrderAmt());
            }
            if (null != reconciliationHis.getOutAmt()) {
                vo.setOrderAmt(reconciliationHis.getOutAmt());
            }
            if (null != reconciliationHis.getOrderId()) {
                vo.setOrderId(reconciliationHis.getOrderId() + "");
            }
            if (null != reconciliationHis.getOrderDate()) {
                vo.setOrderDate(simpleDateFormat.format(reconciliationHis.getOrderDate()));
            }
            if (null != reconciliationHis.getReconciliationDate()) {
                vo.setReconcilDate(simpleDateFormat.format(reconciliationHis.getReconciliationDate()));
            }
            if (null != reconciliationHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconciliationHis.getReconciliationStatus() + ""));
            }
            rows.add(vo);
        }
        data.setRows(rows);
        rspVo.setData(data);
        return rspVo;
    }

    public ReconciliationRspVo getReceiptInfoByTabId(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        Integer tabId = condition.getTabId();
        condition.setReconciliationStatus(tabId);
        Boolean withPage = true;
        switch (tabId) {
            case 0: {
                rspVo = this.getOrderByTabId(condition, withPage);
                break;
            }
            default: {
                rspVo = this.getReceiptInByTabId(condition, tabId, withPage);
            }
        }
        return rspVo;
    }

    public ReconciliationRspVo getExcelByTabId(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        Integer tabId = condition.getTabId();
        Boolean withPage = false;
        switch (tabId) {
            case 0: {
                rspVo = this.getOrderByTabId(condition, withPage);
                break;
            }
            default: {
                rspVo = this.getReceiptInByTabId(condition, tabId, withPage);
            }
        }
        return rspVo;
    }

    public ReconciliationRspVo getReceiptInByTabId(ReconciliationReqBo condition, Integer tabId, boolean withPage) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        ReconciliationDataBo dataBo = new ReconciliationDataBo();
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        List<Object> listrows = new ArrayList();
        Page page = new Page(condition.getPageNo(), condition.getPageSize());
        Map<String, String> reconclStatusMap = this.getReconcilStatusMap();
        if (withPage) {
            condition.setReconciliationStatus(tabId);
            listrows = this.reconcilitionHisMapper.getPageListByCondition(condition, (Page<Map<String, Object>>)page);
        } else {
            condition.setReconciliationStatus(tabId);
            listrows = this.reconcilitionHisMapper.getHisByCondition(condition);
        }
        HashMap reconcilStatusMap = new HashMap();
        for (ReconcilitionHis reconcilitionHis : listrows) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconcilitionHis, (Object)vo);
            if (null != reconcilitionHis.getOrderId()) {
                vo.setOrderId(reconcilitionHis.getOrderId() + "");
            }
            if (null != reconcilitionHis.getReconciliationStatus()) {
                vo.setReconciliStatusName((String)reconcilStatusMap.get(reconcilitionHis.getReconciliationStatus()));
            }
            if (null != reconcilitionHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconcilitionHis.getReconciliationStatus() + ""));
            }
            if (null != reconcilitionHis.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(reconcilitionHis.getOrderDate()));
            }
            if (null != reconcilitionHis.getReconciliationDate()) {
                vo.setReconcilDate(DateUtil.dateToStr(reconcilitionHis.getReconciliationDate()));
            }
            if (null != reconcilitionHis.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(reconcilitionHis.getRecvDate()));
            }
            if (null != reconcilitionHis.getOutAmt()) {
                vo.setOrderAmt(reconcilitionHis.getOutAmt());
            }
            if (null != reconcilitionHis.getOrderAmt()) {
                vo.setEorderAmt(reconcilitionHis.getOrderAmt());
            }
            rows.add(vo);
        }
        dataBo.setRows(rows);
        dataBo.setPageNo(Integer.valueOf(page.getPageNo()));
        dataBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        dataBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspVo.setData(dataBo);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    public ReconciliationRspVo getOrderByTabId(ReconciliationReqBo condition, boolean withPage) {
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        ReconciliationDataBo data = new ReconciliationDataBo();
        List<Object> payPurchaseOrderInfoList = new ArrayList();
        Page page = new Page(condition.getPageNo(), condition.getPageSize());
        if (null == condition.getReconciliationDateStart() && null == condition.getReconciliationrDateEnd()) {
            payPurchaseOrderInfoList = withPage ? this.payPurchaseOrderInfoMapper.getReconclListPage(condition, (Page<Map<String, Object>>)page) : this.payPurchaseOrderInfoMapper.getReconclListPage(condition);
        }
        this.reconcilStatusMap = this.getReconcilStatusMap();
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        Map<String, String> orderStatusMap = this.getOrderStatusMap();
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)vo);
            vo.setOrderId(payPurchaseOrderInfo.getPurchaseOrderCode());
            vo.setOrderStatusName(orderStatusMap.get(payPurchaseOrderInfo.getOrderStatus()));
            if (null != payPurchaseOrderInfo.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(payPurchaseOrderInfo.getOrderDate()));
            }
            if (null != payPurchaseOrderInfo.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(payPurchaseOrderInfo.getRecvDate()));
            }
            if (null != payPurchaseOrderInfo.getReconcilitionStatus()) {
                vo.setReconciliStatusName(this.reconcilStatusMap.get(payPurchaseOrderInfo.getReconcilitionStatus()));
            }
            if (null != payPurchaseOrderInfo.getOrderAmt()) {
                vo.setEorderAmt(payPurchaseOrderInfo.getOrderAmt());
            }
            rows.add(vo);
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspVo.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRows(rows);
        rspVo.setData(data);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    public Map<String, String> getReconcilStatusMap() {
        return null;
    }

    public Map<String, String> getOrderStatusMap() {
        return null;
    }
}

