/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.dao.po;

import java.util.List;

public class Pagination<T> {
    private Integer page;
    private Integer pageCount;
    private Integer totalCount;
    private Integer pageSize;
    private String orderBy;
    private List<T> rows;

    private void fresh() {
        if (this.getTotalCount() == null || this.getPageSize() == null) {
            return;
        }
        int tot = this.getTotalCount();
        int pgCnt = tot / this.getPageSize();
        int mod = this.getTotalCount() % this.getPageSize();
        if (mod > 0) {
            ++pgCnt;
        }
        this.pageCount = pgCnt;
        if (this.getPage() > this.getPageCount()) {
            this.page = this.getPageCount();
        }
    }

    public Integer getPage() {
        if (this.page < 1) {
            this.page = 1;
        }
        return this.page;
    }

    public void setPage(Integer page) {
        if (page < 1) {
            page = 1;
        }
        this.page = page;
        this.fresh();
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
        this.fresh();
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        this.fresh();
    }

    public Integer getPageSize() {
        if (this.pageSize <= 0) {
            this.pageSize = 10;
        }
        return this.pageSize;
    }

    public void setPageSize(Integer countPerPage) {
        if (countPerPage <= 0) {
            countPerPage = 1;
        }
        this.pageSize = countPerPage;
        this.fresh();
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public int getRowIndex() {
        this.fresh();
        int idx = (this.getPage() - 1) * this.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        return idx;
    }

    public String toString() {
        return "Pagination [page=" + this.page + ", pageCount=" + this.pageCount + ", totalCount=" + this.totalCount + ", pageSize=" + this.pageSize + ", orderBy=" + this.orderBy + ", rows=" + this.rows + "]";
    }
}

