/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.supplier.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.supplier.BusiApplyInvoiceService;
import com.tydic.fsc.settle.supplier.bo.BusiApplyInvoiceReqBO;
import com.tydic.fsc.settle.supplier.bo.BusiApplyInvoiceRspBO;
import com.tydic.fsc.settle.supplier.utils.ESBParamUtil;
import com.tydic.fsc.settle.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.settle.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.settle.supplier.utils.http.HttpRetBean;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiApplyInvoiceServiceImpl
implements BusiApplyInvoiceService {
    private static final Log log = LogFactory.getLog(BusiApplyInvoiceServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    @Qualifier(value="propertyConfigurer")
    private Properties prop;

    public BusiApplyInvoiceRspBO applyInvoice(BusiApplyInvoiceReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString()));
        }
        if (null == reqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierOrder()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[supplierOrder]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMarkId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[markId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSettlementId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[settlementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceOrg()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceOrg]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBizInvoiceContent()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[bizInvoiceContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDate()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceDate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTitle()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[title]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceNum()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoicePrice()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoicePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCurrentBatch()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[currentBatch]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalBatch()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[totalBatch]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalBatchInvoiceAmount()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[totalBatchInvoiceAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            System.out.println(reqEsbStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]");
            }
            log.info((Object)("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiApplyInvoiceRspBO invoiceRsp = this.resolveRsp(returnString);
            return invoiceRsp;
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, "\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private String initReqStr(BusiApplyInvoiceReqBO reqBO) {
        StringBuffer supOrSB = new StringBuffer();
        supOrSB.append("[");
        for (int i = 0; i < reqBO.getSupplierOrder().size(); ++i) {
            if (i == 0) {
                supOrSB.append("\"" + (String)reqBO.getSupplierOrder().get(i) + "\"");
                continue;
            }
            supOrSB.append(",").append("\"" + (String)reqBO.getSupplierOrder().get(i) + "\"");
        }
        supOrSB.append("]");
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"supplierOrder\":").append(supOrSB + ",").append("\"markId\":").append("\"" + reqBO.getMarkId() + "\",").append("\"settlementId\":").append("\"" + reqBO.getSettlementId() + "\",").append("\"invoiceType\":").append("" + reqBO.getInvoiceType() + ",").append("\"invoiceOrg\":").append("\"" + reqBO.getInvoiceOrg() + "\",").append("\"bizInvoiceContent\":").append("" + reqBO.getBizInvoiceContent() + ",").append("\"invoiceDate\":").append("\"" + reqBO.getInvoiceDate() + "\",").append("\"title\":").append("\"" + reqBO.getTitle() + "\",").append("\"invoiceNum\":").append("" + reqBO.getInvoiceNum() + ",").append("\"invoicePrice\":").append("" + reqBO.getInvoicePrice() + ",").append("\"currentBatch\":").append("\"" + reqBO.getCurrentBatch() + "\",").append("\"totalBatch\":").append("" + reqBO.getTotalBatch() + ",").append("\"totalBatchInvoiceAmount\":").append("" + reqBO.getTotalBatchInvoiceAmount() + ",").append("\"enterpriseTaxpayer\":").append("\"" + reqBO.getEnterpriseTaxpayer() + "\",").append("\"address\":").append("\"" + reqBO.getAddress() + "\",").append("\"tel\":").append("\"" + reqBO.getTel() + "\",").append("\"bank\":").append("\"" + reqBO.getBank() + "\",").append("\"account\":").append("\"" + reqBO.getAccount() + "\",").append("\"billToParty\":").append("\"" + reqBO.getBillToParty() + "\",").append("\"billToer\":").append("\"" + reqBO.getBillToer() + "\",").append("\"billToContact\":").append("\"" + reqBO.getBillToContact() + "\",").append("\"billToProvince\":").append("" + reqBO.getBillToProvince() + ",").append("\"billToCity\":").append("" + reqBO.getBillToCity() + ",").append("\"billToCounty\":").append("" + reqBO.getBillToCounty() + ",").append("\"billToTown\":").append("" + reqBO.getBillToTown() + ",").append("\"billToAddress\":").append("\"" + reqBO.getBillToAddress() + "\"").append("}");
        return sb.toString();
    }

    private BusiApplyInvoiceRspBO resolveRsp(String returnString) {
        BusiApplyInvoiceRspBO rspBO = new BusiApplyInvoiceRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e));
            }
            throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return rspBO;
    }
}

