/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.supplier.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.supplier.BusiOutStockGoodsTraService;
import com.tydic.fsc.settle.supplier.bo.BusiOutStockGoodsTraDetailReqBO;
import com.tydic.fsc.settle.supplier.bo.BusiOutStockGoodsTraReqBO;
import com.tydic.fsc.settle.supplier.bo.BusiOutStockGoodsTraRspBO;
import com.tydic.fsc.settle.supplier.utils.JsonUtils;
import com.tydic.fsc.settle.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.settle.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.settle.supplier.utils.http.HttpRetBean;
import java.net.URI;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiOutStockGoodsTraServiceImpl
implements BusiOutStockGoodsTraService {
    private static final Logger logger = LoggerFactory.getLogger(BusiOutStockGoodsTraServiceImpl.class);
    @Autowired
    @Qualifier(value="propertyConfigurer")
    private Properties prop;

    public BusiOutStockGoodsTraRspBO receiveStockGoodsTransfer(BusiOutStockGoodsTraReqBO reqBO) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        logger.info("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        if (null == reqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1-\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSeqid())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1-\u552f\u4e00\u6807\u793a[seqid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSsdw())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1-\u6240\u5c5e\u5355\u4f4d[ssdw]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getYhdm())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1-\u7528\u6237\u4ee3\u7801[yhdm]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getYhdm())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1-\u6d41\u7a0bID[flowid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getItems()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1-\u660e\u7ec6[items]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BusiOutStockGoodsTraDetailReqBO detailReqBO : reqBO.getItems()) {
            if (!StringUtils.hasText((String)detailReqBO.getHtbh())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5408\u540c\u7f16\u53f7[htbh]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getWldw())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f80\u6765\u5355\u4f4d[wldw]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getSpzl())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u79cd\u7c7b[spzl]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getCk())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ed3\u5e93[ck]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.hasText((String)detailReqBO.getSpfl())) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5206\u7c7b[spfl]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        logger.info(reqStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_OUTSTOTOTAL_SEND_YUANGUANG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.toString().getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            logger.error("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25,\u552f\u4e00\u6807\u793a\u4e3a" + reqBO.getSeqid(), (Throwable)e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25,\u552f\u4e00\u6807\u793a\u4e3a" + reqBO.getSeqid());
        }
        if (httpRetBean.getStatus() != 200) {
            logger.error("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_OUTSTOTOTAL_SEND_YUANGUANG_URL") + "]");
            throw new RuntimeException("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        logger.info("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            logger.info("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        logger.info("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            logger.error("\u51fa\u5e93\uff08\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\uff09\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u552f\u4e00\u6807\u793a\u4e3a" + reqBO.getSeqid() + " json:" + returnString, (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        BusiOutStockGoodsTraRspBO rspBO = new BusiOutStockGoodsTraRspBO();
        rspBO.setSeqid(rspJsonObject.getString("seqid"));
        rspBO.setCwdjid(rspJsonObject.getString("cwdjid"));
        rspBO.setRspcode(rspJsonObject.getString("rspcode"));
        rspBO.setRspmsg(rspJsonObject.getString("rspmsg"));
        return rspBO;
    }
}

