/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.supplier.utils.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpClientPoolableObjectFactory
extends BasePoolableObjectFactory {
    private static final Log log = LogFactory.getLog(HttpClientPoolableObjectFactory.class);
    private ClientConnectionManager connMng;

    public Object makeObject() throws Exception {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpConnectionParams.setSoReuseaddr((HttpParams)params, (boolean)true);
        HttpConnectionParams.setLinger((HttpParams)params, (int)0);
        params.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        params.setParameter("http.connection.timeout", (Object)30000);
        return new DefaultHttpClient(this.connMng, (HttpParams)params);
    }

    public void shutdownTask() {
        this.connMng.shutdown();
    }

    public HttpClientPoolableObjectFactory(Boolean isHttps) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        if (isHttps.booleanValue()) {
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        } else {
            schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        }
        this.connMng = new ThreadSafeClientConnManager(schemeRegistry);
        ((ThreadSafeClientConnManager)this.connMng).setMaxTotal(1000);
        ((ThreadSafeClientConnManager)this.connMng).setDefaultMaxPerRoute(200);
    }

    public ClientConnectionManager getConnMng() {
        return this.connMng;
    }

    public void setConnMng(ClientConnectionManager connMng) {
        this.connMng = connMng;
    }
}

