/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SftpClient {
    private transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String keyFile;
    private Session session;
    private String currPath = "/";
    private int timeout = 30000;
    ChannelSftp sftp;

    public SftpClient() {
    }

    public SftpClient(String keyFileName) {
        this.keyFile = keyFileName;
    }

    public boolean connect(String host, int port, String username, String password, String rootPath) {
        JSch jsch = new JSch();
        try {
            this.log.info("--SFTP Client,try to connnect server {} {},userName:{}", new Object[]{host, port, username});
            if (this.keyFile != null) {
                File f = new File(this.keyFile);
                if (!f.exists()) {
                    this.log.error("--SFTP Client,Key file [" + this.keyFile + "]not found");
                    return false;
                }
                jsch.addIdentity(this.keyFile);
            }
            this.session = jsch.getSession(username, host, port);
            if (password != null) {
                this.session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect(this.timeout);
            this.log.info("--SFTP Client,Session is connected!");
            Channel channel = this.session.openChannel("sftp");
            channel.connect(this.timeout);
            this.log.info("--SFTP Client,channel is connected successful,sftp is ready!");
            this.sftp = (ChannelSftp)channel;
            if (StringUtils.hasText((String)rootPath)) {
                this.changeDir(rootPath);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("--SFTP Client, access sftp server error," + e.getMessage(), (Throwable)e);
            this.disconnect();
            return false;
        }
    }

    public void disconnect() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.log.info("--SFTP Client,sftp closed!");
    }

    public boolean changeDir(String path) {
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!StringUtils.hasText((String)path)) {
            return true;
        }
        try {
            this.sftp.cd(path);
            if (path.charAt(path.length() - 1) != '/') {
                path = path + "/";
            }
            this.currPath = path;
            return true;
        }
        catch (SftpException e) {
            this.log.error("--SFTP Client,CD " + path + " commond failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<String> list(String path, String pattern) {
        return this.list(path, pattern, false, true, false);
    }

    public List<String> list(String path, String pattern, boolean includeDirectory, boolean includeFile, boolean withFullPath) {
        ArrayList<String> files = new ArrayList<String>();
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return files;
        }
        StringBuilder cmd = new StringBuilder();
        if (!StringUtils.hasText((String)path)) {
            path = this.currPath;
        } else if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        cmd.append(path);
        if (StringUtils.hasText((String)pattern)) {
            cmd.append(pattern);
        }
        Vector ls = null;
        try {
            String cmdText = cmd.toString();
            this.log.info("--SFTP Client,ls cmd [" + cmdText + "]");
            ls = this.sftp.ls(cmdText);
            for (int i = 0; i < ls.size(); ++i) {
                ChannelSftp.LsEntry e = (ChannelSftp.LsEntry)ls.get(i);
                if (includeFile && e.getAttrs().isDir() || includeDirectory && !e.getAttrs().isDir()) continue;
                String fileName = e.getFilename();
                if (withFullPath) {
                    fileName = path + fileName;
                }
                files.add(fileName);
            }
            this.log.info("--SFTP Client,ls get files count=" + ls.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("--SFTP Client,ls [" + cmd + "] cmd failed," + e.getMessage(), (Throwable)e);
        }
        return files;
    }

    public boolean download(String servFileName, String saveLocalPath, String saveToLocalName, boolean autoOverwrite) {
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!StringUtils.hasText((String)saveToLocalName)) {
            int idx = servFileName.lastIndexOf(47);
            saveToLocalName = idx == -1 ? servFileName : servFileName.substring(idx + 1);
        }
        if (StringUtils.hasText((String)saveLocalPath)) {
            File file = new File(saveLocalPath);
            if (!file.exists()) {
                this.log.error("--SFTP Client,download file [" + servFileName + "] failed,localPath" + saveLocalPath + " not exist");
                return false;
            }
            char sign = saveLocalPath.charAt(saveLocalPath.length() - 1);
            if (sign != '/' || sign != '\\') {
                saveLocalPath = saveLocalPath + "/";
            }
        }
        String fullName = saveLocalPath + saveToLocalName;
        File file = new File(fullName);
        if (!autoOverwrite && file.exists()) {
            this.log.info("--SFTP Client,download file skip,target file " + fullName + " exists.");
            return true;
        }
        try {
            long tick = System.currentTimeMillis();
            this.sftp.get(servFileName, (OutputStream)new FileOutputStream(file));
            this.log.info("--SFTP Client,download file [" + servFileName + "] to " + fullName + " successfully,timeCost=" + (System.currentTimeMillis() - tick));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("--SFTP Client,download file [" + servFileName + "] to [" + saveLocalPath + saveToLocalName + "] failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public byte[] download(String servFileName) {
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return null;
        }
        InputStream is = null;
        try {
            long tick = System.currentTimeMillis();
            is = this.sftp.get(servFileName);
            byte[] fileData = IOUtils.toByteArray((InputStream)is);
            this.log.info("--SFTP Client,download file [" + servFileName + "] to buffer successfully,fileSize=" + fileData.length + ",timeCost=" + (System.currentTimeMillis() - tick));
            return fileData;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("--SFTP Client,download file [" + servFileName + "] failed," + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean upload(String servPath, String servFileName, InputStream input) {
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!this.changeDir(servPath)) {
            return false;
        }
        if (servPath.charAt(servPath.length() - 1) != '/') {
            servPath = servPath + "/";
        }
        String fullName = servPath + servFileName;
        try {
            this.sftp.put(input, fullName);
            this.log.info("--SFTP Client,upload to servfile [" + fullName + "] successfully");
            return true;
        }
        catch (SftpException e) {
            e.printStackTrace();
            this.log.error("--SFTP Client,upload to servfile [" + fullName + "] failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean upload(String localFileName, String servPath, String servFileName) {
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        if (!StringUtils.hasText((String)localFileName)) {
            this.log.error("--SFTP Client,not found upload file name.");
            return false;
        }
        File file = new File(localFileName);
        if (!file.exists()) {
            this.log.error("--SFTP Client,upload file [" + localFileName + "] failed,local file not found.");
            return false;
        }
        if (file.isDirectory()) {
            this.log.error("--SFTP Client,upload file name is a directory");
            return false;
        }
        if (!StringUtils.hasText((String)servFileName)) {
            int idx = localFileName.lastIndexOf(92);
            if (idx == -1) {
                idx = localFileName.lastIndexOf(47);
            }
            idx = idx == -1 ? 0 : ++idx;
            servFileName = localFileName.substring(idx);
        }
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            if (fs != null) {
                this.upload(servPath, servFileName, fs);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteFile(String servFileName) {
        if (this.sftp == null) {
            this.log.info("--SFTP Client,operation is failed,sftp is not ready yet");
            return false;
        }
        try {
            this.sftp.rm(servFileName);
            return true;
        }
        catch (SftpException e) {
            this.log.error("--SFTP Client,delete remote file " + servFileName + " failed," + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isReady() {
        return this.sftp != null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static void main(String[] args) {
        SftpClient ftp = new SftpClient();
        ftp.connect("60.205.183.130", 22, "tomcat", "flzx3qC", "/var/ftp/ftptest/downLoad");
        if (ftp.isReady()) {
            List<String> fs = ftp.list("", "pab_505036_20170810_*.txt");
            System.out.println(fs.size() + "===" + fs);
        }
        ftp.disconnect();
    }
}

