/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.tydic.fsc.settle.atom.InvokePaycenterService;
import com.tydic.fsc.settle.atom.bo.OrderBO;
import com.tydic.fsc.settle.atom.bo.ReceiveDetailBO;
import com.tydic.fsc.settle.atom.bo.SaleOrderBO;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderService.class);
    @Autowired
    private InvokePaycenterService invokePaycenterService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public OrderBO obtainOrderInfo(Long purchaseOrderId, Long saleOrderId) {
        OrderBO orderBO = new OrderBO();
        List<PayPurchaseOrderInfo> purchaseOrders = null;
        List<SaleOrderInfo> saleOrders = null;
        if (purchaseOrderId != null) {
            PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setOrderId(purchaseOrderId);
            purchaseOrders = this.payPurchaseOrderInfoMapper.getListByCondition(payPurchaseOrderInfo);
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setPurchaseOrderId(purchaseOrderId);
            saleOrders = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
        } else if (saleOrderId != null) {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setOrderId(saleOrderId);
            saleOrders = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
            if (!CollectionUtils.isEmpty(saleOrders)) {
                purchaseOrderId = saleOrders.get(0).getPurchaseOrderId();
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setOrderId(purchaseOrderId);
                purchaseOrders = this.payPurchaseOrderInfoMapper.getListByCondition(payPurchaseOrderInfo);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseOrders) && !CollectionUtils.isEmpty(saleOrders)) {
            orderBO.setPurchaseOrderId(purchaseOrders.get(0).getOrderId());
            orderBO.setPurchaseOrderCode(purchaseOrders.get(0).getPurchaseOrderCode());
            orderBO.setSaleOrderId(saleOrders.get(0).getOrderId());
            orderBO.setSaleOrderCode(saleOrders.get(0).getSaleOrderCode());
        } else if (purchaseOrderId != null) {
            // empty if block
        }
        return orderBO;
    }

    public SaleOrderBO obtainSaleOrder(Long purchaseOrderId) {
        SaleOrderBO saleOrderBO = new SaleOrderBO();
        if (purchaseOrderId == null) {
            return saleOrderBO;
        }
        saleOrderBO.setPurchaseOrderId(purchaseOrderId);
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setPurchaseOrderId(purchaseOrderId);
        List<SaleOrderInfo> saleOrders = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
        if (!CollectionUtils.isEmpty(saleOrders)) {
            saleOrderBO.setSaleOrderId(saleOrders.get(0).getOrderId());
            saleOrderBO.setSaleOrderCode(saleOrders.get(0).getSaleOrderCode());
        }
        return saleOrderBO;
    }

    public Map<String, ReceiveDetailBO> obtainReceiveDetail(SaleOrderInfoVO saleOrderInfoVO) {
        return null;
    }
}

