/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.tydic.fsc.settle.atom.FscCancelReceiptConfirmAtomService;
import com.tydic.fsc.settle.atom.bo.FscCancelReceiptConfirmAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscCancelReceiptConfirmAtomRspBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAbleInfoMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.RecvAmtDetail;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.RecvAbleInfoVO;
import com.tydic.fsc.settle.dao.vo.RecvAmtDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.RecAmtConfirmStatus;
import com.tydic.fsc.settle.enums.RecvAbleInfoRecvStatus;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscCancelReceiptConfirmAtomService")
public class FscCancelReceiptConfirmAtomServiceImpl
implements FscCancelReceiptConfirmAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscCancelReceiptConfirmAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private RecAmtConfirmMapper recAmtConfirmMapper;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private RecvAmtDetailMapper recvAmtDetailMapper;
    private RecvAbleInfoMapper recvAbleInfoMapper;
    private SaleItemInfoMapper saleItemInfoMapper;

    @Autowired
    private FscCancelReceiptConfirmAtomServiceImpl(RecAmtConfirmMapper recAmtConfirmMapper, AdvanceReceiveMapper advanceReceiveMapper, RecvAmtDetailMapper recvAmtDetailMapper, RecvAbleInfoMapper recvAbleInfoMapper, SaleItemInfoMapper saleItemInfoMapper) {
        this.recAmtConfirmMapper = recAmtConfirmMapper;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.recvAmtDetailMapper = recvAmtDetailMapper;
        this.recvAbleInfoMapper = recvAbleInfoMapper;
        this.saleItemInfoMapper = saleItemInfoMapper;
    }

    @Override
    public FscCancelReceiptConfirmAtomRspBO cancelReceiptConfirm(FscCancelReceiptConfirmAtomReqBO reqBO) {
        FscCancelReceiptConfirmAtomRspBO rspBO = new FscCancelReceiptConfirmAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (!StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        Long docNum = reqBO.getDocNum();
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(docNum);
        String source = recAmtConfirm.getSource();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setDocNum(docNum);
            List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
            for (RecvAmtDetail recvAmtDetail : recvAmtDetailList) {
                AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey(recvAmtDetail.getAdvRecvSeq());
                advanceReceive.setWriteoffAmt(advanceReceive.getWriteoffAmt().subtract(recvAmtDetail.getAmount()));
                advanceReceive.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
                this.advanceReceiveMapper.updateByPrimaryKeySelective(advanceReceive);
            }
            this.recvAmtDetailMapper.deleteByDocNum(docNum);
        } else if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            AdvanceReceive advanceReceive = new AdvanceReceive();
            advanceReceive.setDocNum(docNum);
            this.advanceReceiveMapper.cancelRecAmtConfirm(advanceReceive);
        } else if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            ArrayList<Long> inspectionIdList = new ArrayList<Long>();
            HashMap<Long, AdvanceReceiveVO> advanceReceiveMap = new HashMap<Long, AdvanceReceiveVO>(16);
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setDocNum(docNum);
            List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
            for (RecvAmtDetail recvAmtDetail : recvAmtDetailList) {
                Long seq = recvAmtDetail.getAdvRecvSeq();
                inspectionIdList.add(recvAmtDetail.getInspectionId());
                AdvanceReceiveVO advanceReceiveVO = (AdvanceReceiveVO)advanceReceiveMap.get(seq);
                if (advanceReceiveVO == null) {
                    advanceReceiveVO = new AdvanceReceiveVO();
                    advanceReceiveVO.setSeq(seq);
                    advanceReceiveMap.put(seq, advanceReceiveVO);
                }
                if (recvAmtDetail.getAmount() == null || recvAmtDetail.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                advanceReceiveVO.setNeedUpdateStatus("1");
            }
            this.recvAmtDetailMapper.deleteByDocNum(docNum);
            for (AdvanceReceiveVO advanceReceiveVO : advanceReceiveMap.values()) {
                this.advanceReceiveMapper.cancelRecAmtConfirmXbjDistribute(advanceReceiveVO);
            }
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setInspectionIdList(inspectionIdList);
            List<SaleItemInfo> items = this.saleItemInfoMapper.getList(saleItemInfoVO);
            for (SaleItemInfo item : items) {
                if (!StringUtils.hasText((String)item.getApplyNo())) continue;
                RecvAbleInfoVO recvAbleInfoVO = new RecvAbleInfoVO();
                recvAbleInfoVO.setOrderId(item.getOrderId());
                recvAbleInfoVO.setInvoiceApyNo(item.getApplyNo());
                recvAbleInfoVO.setRecvStatusOld(RecvAbleInfoRecvStatus.RECEIVED.getCode());
                recvAbleInfoVO.setWriteoffAmt(BigDecimal.ZERO);
                recvAbleInfoVO.setRecvStatus(RecvAbleInfoRecvStatus.TO_RECEIVE.getCode());
                recvAbleInfoVO.setRecvRemark("\u53d6\u6d88\u6536\u6b3e\u5355");
                this.recvAbleInfoMapper.updateByConditions(recvAbleInfoVO);
            }
        }
        recAmtConfirm = new RecAmtConfirm();
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setStatus(RecAmtConfirmStatus.INVALID.getCode());
        recAmtConfirm.setUpdateDate(new Date());
        this.recAmtConfirmMapper.updateByPrimaryKeySelective(recAmtConfirm);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53d6\u6d88\u6536\u6b3e\u786e\u8ba4\u5355\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscCancelReceiptConfirmAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getDocNum()) {
            return "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

