/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.tydic.fsc.settle.atom.FscCancelSupPayReceiptOrderAtomService;
import com.tydic.fsc.settle.atom.bo.FscCancelSupPayReceiptOrderAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscCancelSupPayReceiptOrderAtomRspBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveExtMapper;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.AdvanceReceiveExtPO;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.RecvAmtDetail;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.RecvAmtDetailVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.RecAmtConfirmStatus;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscCancelSupPayReceiptOrderAtomService")
public class FscCancelSupPayReceiptOrderAtomServiceImpl
implements FscCancelSupPayReceiptOrderAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscCancelSupPayReceiptOrderAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private RecvAmtDetailMapper recvAmtDetailMapper;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    private RecAmtConfirmMapper recAmtConfirmMapper;
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;

    @Autowired
    private FscCancelSupPayReceiptOrderAtomServiceImpl(RecvAmtDetailMapper recvAmtDetailMapper, AdvanceReceiveMapper advanceReceiveMapper, InquiryPayOrderMapper inquiryPayOrderMapper, RecAmtConfirmMapper recAmtConfirmMapper, AdvanceReceiveExtMapper advanceReceiveExtMapper) {
        this.recvAmtDetailMapper = recvAmtDetailMapper;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.inquiryPayOrderMapper = inquiryPayOrderMapper;
        this.recAmtConfirmMapper = recAmtConfirmMapper;
        this.advanceReceiveExtMapper = advanceReceiveExtMapper;
    }

    @Override
    public FscCancelSupPayReceiptOrderAtomRspBO cancelSupPayReceiptOrder(FscCancelSupPayReceiptOrderAtomReqBO reqBO) {
        FscCancelSupPayReceiptOrderAtomRspBO rspBO = new FscCancelSupPayReceiptOrderAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (!StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        Long docNum = reqBO.getDocNum();
        InquiryPayOrderExt payExt = new InquiryPayOrderExt();
        payExt.setDocNum(docNum);
        payExt.setPaymentStatus(InquiryPaymentStatus.REC_CONFIRMED.getCode());
        List<InquiryPayOrder> inquiryPayOrderList = this.inquiryPayOrderMapper.getList(payExt);
        for (InquiryPayOrder inquiryPayOrder : inquiryPayOrderList) {
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setPayOrderNo(inquiryPayOrder.getPayOrderNo());
            recvAmtDetailVO.setDocNum(docNum);
            List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
            for (RecvAmtDetail recvAmtDetail : recvAmtDetailList) {
                AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey(recvAmtDetail.getAdvRecvSeq());
                if (advanceReceive != null) {
                    AdvanceReceiveVO updateAdvance = new AdvanceReceiveVO();
                    updateAdvance.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
                    updateAdvance.setSeq(advanceReceive.getSeq());
                    updateAdvance.setWriteoffAmt(advanceReceive.getWriteoffAmt().subtract(recvAmtDetail.getAmount()));
                    AdvanceReceive updateAdvancePo = new AdvanceReceive();
                    BeanUtils.copyProperties((Object)updateAdvance, (Object)updateAdvancePo);
                    this.advanceReceiveMapper.updateByPrimaryKeySelective(updateAdvancePo);
                    continue;
                }
                AdvanceReceiveExtPO advancePO = this.advanceReceiveExtMapper.selectByPrimaryKey(recvAmtDetail.getAdvRecvSeq());
                if (advancePO == null) continue;
                AdvanceReceiveExtPO updateAdvanceExt = new AdvanceReceiveExtPO();
                updateAdvanceExt.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
                updateAdvanceExt.setSeq(advancePO.getSeq());
                updateAdvanceExt.setWriteoffAmt(advancePO.getWriteoffAmt().subtract(recvAmtDetail.getAmount()));
                this.advanceReceiveExtMapper.updateByPrimaryKeySelective(updateAdvanceExt);
            }
            InquiryPayOrderExt updateInquiry = new InquiryPayOrderExt();
            updateInquiry.setDocNum(null);
            updateInquiry.setPaymentStatus(inquiryPayOrder.getPaymentStatusOld());
            updateInquiry.setPayOrderNo(inquiryPayOrder.getPayOrderNo());
            updateInquiry.setPaymentStatusOld(null);
            this.inquiryPayOrderMapper.updateStateByPayOrderNo(updateInquiry);
        }
        this.recvAmtDetailMapper.deleteByDocNum(docNum);
        RecAmtConfirm recAmtConfirm = new RecAmtConfirm();
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setStatus(RecAmtConfirmStatus.INVALID.getCode());
        recAmtConfirm.setUpdateDate(new Date());
        this.recAmtConfirmMapper.updateByPrimaryKeySelective(recAmtConfirm);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscCancelSupPayReceiptOrderAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getDocNum()) {
            return "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

