/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.SubAccountStatus;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subAccountRespInitService")
public class SubAccountRespInitServiceImpl
implements SubAccountRespInitService {
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private EnumsService enumsService;

    @Override
    public void initRespBo(SubAcctInfoExt subAcct, BusiSubAccountInfoRspBO respBo) {
        CompanyType companyType;
        SubAccountStatus sta;
        SubAccountServiceType srvType;
        BeanUtils.copyProperties((Object)subAcct, (Object)respBo);
        respBo.setCreateUser(subAcct.getLoginId());
        respBo.setCreateOrgId(subAcct.getCreateOrgId());
        respBo.setUpdateUser(subAcct.getUpdateId());
        respBo.setUpdateOrgId(subAcct.getUpdateOrgId());
        respBo.setSubAcctNo(subAcct.getSubAcctNo());
        respBo.setAcctCompanyType(subAcct.getCompanyType());
        respBo.setAcctOrgId(subAcct.getOrgId());
        String name = this.orgService.queryOrgName(subAcct.getOrgId());
        respBo.setAcctOrgName(name);
        name = this.orgService.queryProjectName(subAcct.getProjectId());
        respBo.setProjectDescr(name);
        respBo.setSuperiorOrgName(this.orgService.queryOrgName(subAcct.getSuperiorOrgId()));
        OrderSource ordSource = OrderSource.getInstance((String)subAcct.getSource());
        if (ordSource != null) {
            name = this.enumsService.getDescr((BaseEnums)ordSource);
            respBo.setSourceDescr(name);
        }
        if ((srvType = SubAccountServiceType.convert(subAcct.getServiceType())) != null) {
            name = this.enumsService.getDescr(srvType);
            respBo.setServiceTypeDescr(name);
        }
        if ((sta = SubAccountStatus.getCode(subAcct.getStatus())) != null) {
            name = this.enumsService.getDescr(sta);
            respBo.setStatusDescr(name);
        }
        if ((companyType = CompanyType.convert(subAcct.getCompanyType())) != null) {
            respBo.setAcctCompanyTypeDescr(companyType.getDescr());
        }
    }
}

