/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.fsc.settle.atom.WFPayStartBusiService;
import com.tydic.fsc.settle.atom.bo.PayStartBusiReqBO;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAddRecAmtConfirmService;
import com.tydic.fsc.settle.busi.api.bo.BusiAddRecAmtConfirmReqBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.RecvAmtDetail;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.RecvAmtDetailVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.RecAmtConfirmStatus;
import com.tydic.fsc.settle.enums.ReceiptStatus;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.WFBillType;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAddRecAmtConfirmServiceImpl
implements BusiAddRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddRecAmtConfirmServiceImpl.class);
    @Autowired
    @Qualifier(value="recAmtConfirmReq")
    private OrderSequence recAmtConfirmReq;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private WFPayStartBusiService wfPayStartBusiService;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;

    public FscBaseRspBo addRecAmtConfirm(BusiAddRecAmtConfirmReqBO reqBO) {
        List seqList;
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((seqList = reqBO.getSeqList()) == null || seqList.isEmpty()) {
            throw new BusinessException("1001", "\u60a8\u6ca1\u6709\u52fe\u9009\u6536\u6b3e\u4fe1\u606f");
        }
        AdvanceReceiveVO adReVo = new AdvanceReceiveVO();
        adReVo.setSeqList(seqList);
        adReVo.setServiceTypeNotIn(Arrays.asList(SubAccountServiceType.DEFAULT.getCode()));
        int valCount = this.advanceReceiveMapper.selectCountBySeqList(adReVo);
        if (valCount > 0) {
            throw new BusinessException("1002", "\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u7684\u94f6\u884c\u6d41\u6c34\u53ef\u4ee5\u529e\u7406\u6b64\u4e1a\u52a1\uff0c\u8fd0\u8425\u5355\u4f4d\u8d26\u6237\u4e0d\u53ef\u4ee5");
        }
        RecAmtConfirm recAmtConfirm = new RecAmtConfirm();
        long seqId = 0L;
        try {
            seqId = this.recAmtConfirmReq.nextId();
        }
        catch (SQLException e) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u4ea7\u751f\u5e8f\u5217\u53f7\u5931\u8d25");
        }
        Long docNum = this.generateSeqNoFormated(18, new SimpleDateFormat("yyyyMMdd").format(new Date()), seqId);
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setCreateDate(new Date());
        AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey((Long)seqList.get(0));
        recAmtConfirm.setOrgId(advanceReceive.getRecOrgId());
        recAmtConfirm.setSource(advanceReceive.getSource());
        recAmtConfirm.setLoginId(reqBO.getUserId());
        recAmtConfirm.setRemark(reqBO.getRemark());
        recAmtConfirm.setStatus(RecAmtConfirmStatus.VALID.getCode());
        recAmtConfirm.setReceiptStatus(ReceiptStatus.NO_RECEIPT.getCode());
        BigDecimal sumAmt = null;
        Integer sumCount = null;
        String source = advanceReceive.getSource();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
            AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
            advanceReceiveVO.setSeqList(seqList);
            advanceReceiveVO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            List<AdvanceReceive> advanceReceiveList = this.advanceReceiveMapper.selectByCondition(advanceReceiveVO);
            ArrayList<RecvAmtDetail> recvDetailList = new ArrayList<RecvAmtDetail>();
            for (AdvanceReceive advanceReceiveInfo : advanceReceiveList) {
                SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectByPrimaryKey(advanceReceiveInfo.getRecSubAcct());
                AdvanceReceive record = new AdvanceReceive();
                record.setSeq(advanceReceiveInfo.getSeq());
                record.setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
                record.setWriteoffAmt(advanceReceiveInfo.getTranAmt());
                this.advanceReceiveMapper.updateByPrimaryKeySelective(record);
                RecvAmtDetail recvDetail = new RecvAmtDetail();
                recvDetail.setAdvRecvSeq(advanceReceiveInfo.getSeq());
                recvDetail.setAmount(advanceReceiveInfo.getTranAmt().subtract(advanceReceiveInfo.getWriteoffAmt()));
                recvDetail.setOperUnitNo(advanceReceive.getRecOrgId());
                recvDetail.setPurchaseNo(subAcctInfo.getOrgId());
                recvDetail.setPurchaseProjectId(subAcctInfo.getProjectId());
                recvDetail.setDocNum(docNum);
                recvDetail.setLoginId(reqBO.getUserId());
                recvDetail.setCreateDate(new Date());
                recvDetailList.add(recvDetail);
            }
            this.recvAmtDetailMapper.insertByBatch(recvDetailList);
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setDocNum(docNum);
            recvAmtDetailVO = this.recvAmtDetailMapper.selectSum2(recvAmtDetailVO);
            sumAmt = recvAmtDetailVO.getAmount();
            sumCount = recvAmtDetailVO.getCount();
        } else if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            AdvanceReceiveVO vo = new AdvanceReceiveVO();
            vo.setSeqList(seqList);
            vo.setStatusEqual(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            vo.setDocNum(docNum);
            vo.setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
            this.advanceReceiveMapper.confirm(vo);
            AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
            advanceReceiveVO.setDocNum(docNum);
            advanceReceiveVO = this.advanceReceiveMapper.selectSum(advanceReceiveVO);
            sumAmt = advanceReceiveVO.getTranAmt();
            sumCount = advanceReceiveVO.getCount();
        }
        recAmtConfirm.setSumAmt(sumAmt);
        recAmtConfirm.setSumCount(sumCount);
        this.recAmtConfirmMapper.insert(recAmtConfirm);
        PayStartBusiReqBO req = new PayStartBusiReqBO();
        req.setUserId(reqBO.getUserId());
        req.setBillNo(String.valueOf(docNum));
        req.setBillType(WFBillType.COLLECTION_CONFIRMATION);
        req.setFinishEvtServiceId("recAmtConfirmWorkFlowFinshEventImpl");
        this.wfPayStartBusiService.addApproveFlow(req);
        return new FscBaseRspBo();
    }

    private Long generateSeqNoFormated(int length, String prefix, long seqId) {
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = length - prefix.length();
        String withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", seqId);
        return Long.parseLong(prefix + withoutPrefix);
    }
}

