/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiCancelNotificationService;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelNotificationReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelNotificationRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayInvoiceInfoVO;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.supplier.BusiGetInvoiceDataService;
import com.tydic.fsc.settle.supplier.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.fsc.settle.supplier.vo.BusiGetInvoiceDataRspVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiCancelNotificationServiceImpl
implements BusiCancelNotificationService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelNotificationServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public BusiCancelNotificationRspBO cancelNotification(BusiCancelNotificationReqBO reqBO) {
        logger.info("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u8bf7\u6c42BO\uff1a" + reqBO + ",\u64cd\u4f5c\u4eba\uff1a" + reqBO.getUserName());
        String notificationNo = reqBO.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new BusinessException("1001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u5fc5\u987b\u8f93\u5165");
        }
        if (reqBO.getConfirmFlag() == null) {
            throw new BusinessException("1001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u786e\u8ba4\u6807\u8bc6[confirmFlag]\u5fc5\u987b\u8f93\u5165");
        }
        if (companyId == null) {
            throw new BusinessException("1001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5728\u8bf7\u6c42\u6570\u636e\u4e2d\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(notificationNo, companyId);
        if (bill == null) {
            throw new BusinessException("1001", "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        }
        String source = bill.getSource();
        if (NotificationInvoiceStatus.RECEIVED.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.RETURN_BACK.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.HAS_CANCEL.getCode().equals(bill.getInvoiceStatus())) {
            throw new BusinessException("1001", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        BusiCancelNotificationRspBO rsp = new BusiCancelNotificationRspBO();
        String alertMsg = null;
        if (reqBO.getConfirmFlag().booleanValue()) {
            PayInvoiceInfoVO payInvoiceInfoVO = new PayInvoiceInfoVO();
            payInvoiceInfoVO.setNotificationNo(notificationNo);
            int count = this.payInvoiceInfoMapper.selectCount(payInvoiceInfoVO);
            if (count > 0) {
                throw new BusinessException("1002", "\u5df2\u6709\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            BillNotificationInfo updBill = new BillNotificationInfo();
            updBill.setNotificationNo(notificationNo);
            updBill.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(updBill);
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                for (PayPurchaseOrderInfo singleOrder : orders) {
                    this.payPurchaseOrderInfoMapper.updateByReset(singleOrder);
                    PayItemInfo item = new PayItemInfo();
                    item.setOrderId(singleOrder.getOrderId());
                    item.setInspectionId(singleOrder.getInspectionId());
                    this.payItemInfoMapper.updateByReset(item);
                }
            } else {
                List<PayItemInfo> items = this.payItemInfoMapper.selectByNotifNo(notificationNo);
                HashSet<Long> inspectionIdSet = new HashSet<Long>();
                ArrayList<Long> seqList = new ArrayList<Long>();
                for (PayItemInfo singleItem : items) {
                    inspectionIdSet.add(singleItem.getInspectionId());
                    seqList.add(singleItem.getSeq());
                }
                PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
                payItemInfoVO.setSeqList(seqList);
                this.payItemInfoMapper.updateByResetDlzq(payItemInfoVO);
                for (Long inspectionId : inspectionIdSet) {
                    PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                    payPurchaseOrderInfo.setInspectionId(inspectionId);
                    this.payPurchaseOrderInfoMapper.updateByResetDlzq(payPurchaseOrderInfo);
                }
            }
        } else if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            String markId = bill.getNotificationNo();
            String id = String.valueOf(bill.getSupplierNo());
            dataMap.put(markId, id);
            BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
            getInvoiceDataReqBO.setIdMap(dataMap);
            List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
            alertMsg = null == invoiceDataList || invoiceDataList.isEmpty() ? "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a" : "\u901a\u77e5\u5355\u7684\u5f00\u7968\u72b6\u51b5\uff1a" + ((BusiGetInvoiceDataRspVO)invoiceDataList.get(0)).getResultMsg();
        } else {
            alertMsg = "\u786e\u5b9a\u8981\u53d6\u6d88\u5f53\u524d\u5f00\u7968\u901a\u77e5\u5355\u5417?";
        }
        logger.info("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1\uff0c\u6267\u884c\u5b8c\u6210\uff0c\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + notificationNo + "\u64cd\u4f5c\u4eba\uff1a" + reqBO.getUserName());
        rsp.setAlertMsg(alertMsg);
        return rsp;
    }
}

