/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiExportInSummaryBillService;
import com.tydic.fsc.settle.busi.api.bo.BusiExportInSummaryBillRspBO;
import com.tydic.fsc.settle.busi.api.bo.EntryTotalInfoBO;
import com.tydic.fsc.settle.busi.api.bo.InSummaryBO;
import com.tydic.fsc.settle.busi.api.bo.PayInvoiceInfoBO;
import com.tydic.fsc.settle.busi.api.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.fsc.settle.busi.api.vo.PayInvoiceInfoVO;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.utils.AmountUtils;
import com.tydic.fsc.settle.utils.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportInSummaryBillServiceimpl
implements BusiExportInSummaryBillService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportInSummaryBillServiceimpl.class);
    @Autowired
    PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    EntryInfoMapper entryInfoMapper;
    @Autowired
    PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    OrganizationInfoService organizationInfoService;

    public BusiExportInSummaryBillRspBO export(List<EntryTotalInfoBO> entryTotalInfoBOS) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u5165\u5e93\u5355\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + entryTotalInfoBOS);
        }
        BusiExportInSummaryBillRspBO resp = new BusiExportInSummaryBillRspBO();
        ArrayList<InSummaryBO> rows = new ArrayList<InSummaryBO>();
        List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOList = null;
        BigDecimal nottaxAmtSum = BigDecimal.ZERO;
        BigDecimal taxAmtSum = BigDecimal.ZERO;
        BigDecimal amtSum = BigDecimal.ZERO;
        for (EntryTotalInfoBO entryTotalInfoBO : entryTotalInfoBOS) {
            EntryInfoPO entryInfoPO = new EntryInfoPO();
            entryInfoPO.setApplyNo(entryTotalInfoBO.getApplyNo());
            List<EntryInfoPO> entryInfoList = this.entryInfoMapper.getList(entryInfoPO);
            for (EntryInfoPO entryInfoPO1 : entryInfoList) {
                InSummaryBO inSummaryBO = new InSummaryBO();
                payPurchaseOrderInfoDetailBOList = this.payPurchaseOrderInfoMapper.getListByNo(entryInfoPO1.getNotificationNo());
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < payPurchaseOrderInfoDetailBOList.size(); ++i) {
                    String purchaseName = this.organizationInfoService.queryProjectName(payPurchaseOrderInfoDetailBOList.get(i).getPurchaseProjectId());
                    map.put(payPurchaseOrderInfoDetailBOList.get(i).getPurchaseOrderCode(), purchaseName);
                }
                ArrayList<String> purchaseOrderCodes = new ArrayList<String>();
                ArrayList purchaseNames = new ArrayList();
                for (String code : map.keySet()) {
                    purchaseOrderCodes.add(code);
                    purchaseNames.add(map.get(code));
                }
                String purchaseName = StringUtils.list2String(purchaseNames, ",");
                String purchaseOrderCode = StringUtils.list2String(purchaseOrderCodes, ",");
                inSummaryBO.setApplyNo(entryInfoPO.getApplyNo());
                inSummaryBO.setPurchaseName(purchaseName);
                inSummaryBO.setPurchaseOrderCode(purchaseOrderCode);
                inSummaryBO.setSupplierName(payPurchaseOrderInfoDetailBOList.get(0).getSupplierName());
                List<PayInvoiceInfoBO> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNo(entryInfoPO1.getNotificationNo());
                ArrayList<PayInvoiceInfoVO> voList = new ArrayList<PayInvoiceInfoVO>();
                for (PayInvoiceInfoBO payInvoiceInfoBO : payInvoiceInfoList) {
                    PayInvoiceInfoVO payInvoiceInfoVO = new PayInvoiceInfoVO();
                    payInvoiceInfoVO.setInvoiceNo(payInvoiceInfoBO.getInvoiceNo());
                    payInvoiceInfoVO.setAmt(AmountUtils.format(payInvoiceInfoBO.getAmt()));
                    payInvoiceInfoVO.setNotTaxAmt(AmountUtils.format(payInvoiceInfoBO.getNotTaxAmt()));
                    payInvoiceInfoVO.setTaxAmt(AmountUtils.format(payInvoiceInfoBO.getTaxAmt()));
                    payInvoiceInfoVO.setTaxRate(StringUtils.valueOf(AmountUtils.calcTaxRate(payInvoiceInfoBO.getTaxAmt(), payInvoiceInfoBO.getNotTaxAmt())));
                    voList.add(payInvoiceInfoVO);
                    nottaxAmtSum = nottaxAmtSum.add(payInvoiceInfoBO.getNotTaxAmt());
                    taxAmtSum = taxAmtSum.add(payInvoiceInfoBO.getTaxAmt());
                    amtSum = amtSum.add(payInvoiceInfoBO.getAmt());
                }
                InvoiceType vt = InvoiceType.getInstance(payInvoiceInfoList.get(0).getInvoiceType());
                if (vt != null) {
                    inSummaryBO.setInvoiceTypeDescr(vt.getDescr());
                }
                inSummaryBO.setPayInvoiceInfoVOs(voList);
                rows.add(inSummaryBO);
            }
        }
        resp.setRows(rows);
        resp.setAmtSum(AmountUtils.format(amtSum));
        resp.setNotTaxAmtSum(AmountUtils.format(nottaxAmtSum));
        resp.setTaxAmtSum(AmountUtils.format(taxAmtSum));
        return resp;
    }
}

