/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.bo.FscPageReqBo;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.BusiQryNotificationListDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNotificationListReqBO;
import com.tydic.fsc.settle.busi.api.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.vo.BillNotificationInfoVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.dao.vo.Statis;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.utils.BusinessUtils;
import com.tydic.fsc.settle.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryNotificationListDlzqServiceImpl
implements BusiQryNotificationListDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationListDlzqServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public FscPageRspBo<BillNotificationInfoVO> qryNotifyList(BusiQryNotificationListReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("1001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new BusinessException("1001", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long operUnitNo = BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false);
        reqBO.setOperUnitNo(operUnitNo);
        String defaultOrderBy = " APPLY_DATE desc,NOTIFICATION_NO desc ";
        String tableName = "d_bill_notification_info";
        String orderBy = StringUtils.obtainOrderBy((FscPageReqBo)reqBO, tableName, defaultOrderBy);
        FscPageRspBo rspPageBO = new FscPageRspBo();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        LinkedList<BillNotificationInfoVO> result = new LinkedList<BillNotificationInfoVO>();
        List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(reqBO, false, (Page<Map<String, Object>>)page, orderBy);
        for (BillNotificationInfo notifyInfo : resultPO) {
            BillNotificationInfoVO resultVO = new BillNotificationInfoVO();
            BeanUtils.copyProperties((Object)notifyInfo, (Object)resultVO);
            resultVO.setNotifInvoiceStatus(notifyInfo.getInvoiceStatus());
            NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(resultVO.getNotifInvoiceStatus());
            resultVO.setNotifInvoiceStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
            String supplierStr = this.organizationInfoService.querySupplierName(resultVO.getSupplierNo());
            resultVO.setSupplierName(supplierStr);
            resultVO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)resultVO.getSource())));
            resultVO.setVerifyPersonName(this.userInfoService.queryUserNameByUserId(notifyInfo.getVerifyPersonId()));
            resultVO.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(resultVO.getProfessionalDepartId()));
            resultVO.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(resultVO.getServiceDepartId()));
            resultVO.setBranchCompanyName(this.organizationInfoService.queryOrgName(notifyInfo.getBranchCompany()));
            LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
            LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
            PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            purchaseOrderInfoVO.setNotificationNo(notifyInfo.getNotificationNo());
            List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
            for (PayPurchaseOrderInfo purchaseOrderInfo : purchaseOrderInfos) {
                PurchaseOrderDetailInfoRspBO detailRspBO = new PurchaseOrderDetailInfoRspBO();
                detailRspBO.setInspectionId(purchaseOrderInfo.getInspectionId());
                detailRspBO.setPurchaseOrderCode(purchaseOrderInfo.getPurchaseOrderCode());
                detailRspBO.setPurchaseOrderName(purchaseOrderInfo.getPurchaseOrderName());
                purchaseOrderDetailList.add(detailRspBO);
                purchaseOrderNameList.add(purchaseOrderInfo.getPurchaseOrderName());
            }
            resultVO.setPurchaseOrderCodeList(purchaseOrderDetailList);
            resultVO.setPurchaseOrderNameList(purchaseOrderNameList);
            resultVO.setAmtDifference(resultVO.getAmt());
            Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(notifyInfo.getNotificationNo());
            if (null != ivStatis) {
                resultVO.setSumInvoiceAmt(ivStatis.getTotAmt());
                resultVO.setTotUntaxAmt(ivStatis.getTotUntaxAmt());
                resultVO.setTotTaxAmt(ivStatis.getTotTaxAmt());
                if (null != resultVO.getAmt() && null != resultVO.getSumInvoiceAmt()) {
                    resultVO.setAmtDifference(resultVO.getAmt().subtract(resultVO.getSumInvoiceAmt()));
                }
            }
            result.add(resultVO);
        }
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

