/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiQueryInvoiceVerifyService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryInvoiceVerifyDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryInvoiceVerifyReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryInvoiceVerifyRspBO;
import com.tydic.fsc.settle.busi.api.vo.BillNotificationMatchingResult;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.vo.Statis;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryInvoiceVerifyServiceImpl
implements BusiQueryInvoiceVerifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryInvoiceVerifyServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    public BusiQueryInvoiceVerifyRspBO query(BusiQueryInvoiceVerifyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u53d1\u7968\u6838\u5bf9\u6821\u9a8c\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List notificationNos = reqBO.getNotificationNos();
        if (CollectionUtils.isEmpty((Collection)notificationNos)) {
            throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryInvoiceVerifyRspBO queryInvoiceVerifyServiceRspBO = new BusiQueryInvoiceVerifyRspBO();
        queryInvoiceVerifyServiceRspBO.setVerifyDetailList(new LinkedList());
        LinkedList<BusiQueryInvoiceVerifyDetailRspBO> matchingDetailList = new LinkedList<BusiQueryInvoiceVerifyDetailRspBO>();
        LinkedList<BusiQueryInvoiceVerifyDetailRspBO> misMatchingDetailList = new LinkedList<BusiQueryInvoiceVerifyDetailRspBO>();
        Long companyId = reqBO.getCompanyId();
        for (String notificationNo : notificationNos) {
            BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            if (bill == null) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",companyId=" + companyId);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u5355\u53f7" + notificationNo + "\u4e0d\u5b58\u5728!");
            }
            if (!companyId.equals(bill.getOperNo())) {
                throw new BusinessException("8888", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
            }
            String billSta = bill.getInvoiceStatus();
            NotificationInvoiceStatus nowSta = NotificationInvoiceStatus.getInstance(billSta);
            if (nowSta == null) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5355\u72b6\u6001=" + billSta);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u77e5\u5355" + notificationNo + "\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u65e0\u6548\u7684\u53d1\u7968\u72b6\u6001\u503c");
            }
            if (NotificationInvoiceStatus.RECEIVED == nowSta) continue;
            if (NotificationInvoiceStatus.HAS_MAKE != nowSta) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e0d\u662f\u5df2\u5f00\u7968(02),\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5355\u72b6\u6001=" + billSta);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u77e5\u5355" + notificationNo + "\u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u6838\u5bf9\u64cd\u4f5c");
            }
            List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
            logger.debug("\u53d1\u7968\u6838\u5bf9,\u901a\u77e5\u5355\u5185\u6d89\u53ca\u53d1\u7968\u6570\u91cf=" + invoices.size() + ",\u901a\u77e5\u5355\u53f7=" + notificationNo);
            if (invoices.size() == 0) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968,\u901a\u77e5\u5355\u53f7=" + notificationNo);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u627e\u5230\u901a\u77e5\u5355" + notificationNo + "\u5bf9\u5e94\u7684\u53d1\u7968");
            }
            Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(notificationNo);
            Statis ordStatis = this.payItemInfoMapper.orderStatis(notificationNo);
            logger.debug("\u53d1\u7968\u6838\u5bf9,\u8ba2\u5355\u5546\u54c1\u7edf\u8ba1=" + ordStatis);
            logger.debug("\u53d1\u7968\u6838\u5bf9,\u53d1\u7968\u5546\u54c1\u660e\u7ec6\u7edf\u8ba1=" + ivStatis);
            List<PayItemInfo> sampsInOrders = this.payItemInfoMapper.selectByNotifNoAndOrderId(notificationNo, null, null);
            logger.debug("\u53d1\u7968\u6838\u5bf9,\u901a\u77e5\u5355\u5185\u5546\u54c1\u660e\u7ec6\u6570\u91cf=" + sampsInOrders.size() + ",\u901a\u77e5\u5355\u53f7=" + notificationNo);
            if (sampsInOrders.size() == 0) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u8ba2\u5355\u53ca\u5176\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + notificationNo);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u627e\u5230\u901a\u77e5\u5bf9\u5e94\u7684\u8ba2\u5355\u53ca\u5176\u5546\u54c1\u660e\u7ec6");
            }
            BusiQueryInvoiceVerifyDetailRspBO verifyDetailRspBO = new BusiQueryInvoiceVerifyDetailRspBO();
            verifyDetailRspBO.setNotificationNo(notificationNo);
            verifyDetailRspBO.setOrderAmount(ordStatis.getTotAmt());
            verifyDetailRspBO.setOrderUntaxAmt(ordStatis.getTotUntaxAmt());
            verifyDetailRspBO.setOrderTaxAmt(ordStatis.getTotTaxAmt());
            verifyDetailRspBO.setInvoiceAmount(ivStatis.getTotAmt());
            verifyDetailRspBO.setInvoiceTaxAmt(ivStatis.getTotTaxAmt());
            verifyDetailRspBO.setInvoiceUntaxAmt(ivStatis.getTotUntaxAmt());
            this.verify(reqBO, verifyDetailRspBO, bill, invoices, sampsInOrders);
            if (1 == verifyDetailRspBO.getVerifyResult()) {
                matchingDetailList.add(verifyDetailRspBO);
                continue;
            }
            misMatchingDetailList.add(verifyDetailRspBO);
        }
        this.ascSortForNotificationNoList(matchingDetailList);
        this.ascSortForNotificationNoList(misMatchingDetailList);
        queryInvoiceVerifyServiceRspBO.getVerifyDetailList().addAll(matchingDetailList);
        queryInvoiceVerifyServiceRspBO.getVerifyDetailList().addAll(misMatchingDetailList);
        return queryInvoiceVerifyServiceRspBO;
    }

    private void verify(BusiQueryInvoiceVerifyReqBO reqBO, BusiQueryInvoiceVerifyDetailRspBO resp, BillNotificationInfo bill, List<PayInvoiceInfo> invoices, List<PayItemInfo> sampsInOrders) {
        PayInvoiceInfo invoice = invoices.get(0);
        resp.setSummaries(new ArrayList());
        resp.setVerifyResult(Integer.valueOf(1));
        if (bill.getSupplierNo() != null && bill.getSupplierNo() == 1L) {
            invoice.setName(StringUtils.hasText((String)invoice.getName()) ? invoice.getName() : bill.getInvoceName());
            invoice.setTaxNo(StringUtils.hasText((String)invoice.getTaxNo()) ? invoice.getTaxNo() : bill.getTaxNo());
            invoice.setAddress(StringUtils.hasText((String)invoice.getAddress()) ? invoice.getAddress() : bill.getAddr());
            invoice.setPhone(StringUtils.hasText((String)invoice.getPhone()) ? invoice.getPhone() : bill.getPhone());
            invoice.setBankName(StringUtils.hasText((String)invoice.getBankName()) ? invoice.getBankName() : bill.getBankName());
            invoice.setBankAcNo(StringUtils.hasText((String)invoice.getBankAcNo()) ? invoice.getBankAcNo() : bill.getBankAccNo());
        }
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u6c47\u603b\u91d1\u989d(\u542b\u7a0e)", (Object)resp.getOrderAmount(), (Object)resp.getInvoiceAmount()));
        BillNotificationMatchingResult untaxAmtMatchingResult = new BillNotificationMatchingResult();
        untaxAmtMatchingResult = untaxAmtMatchingResult.compare("\u6c47\u603b\u91d1\u989d(\u4e0d\u542b\u7a0e)", (Object)resp.getOrderUntaxAmt(), (Object)resp.getInvoiceUntaxAmt());
        untaxAmtMatchingResult.setMatched(Integer.valueOf(1));
        resp.getSummaries().add(untaxAmtMatchingResult);
        BillNotificationMatchingResult taxAmtMatchingResult = new BillNotificationMatchingResult();
        taxAmtMatchingResult = taxAmtMatchingResult.compare("\u7a0e\u989d", (Object)resp.getOrderTaxAmt(), (Object)resp.getInvoiceTaxAmt());
        taxAmtMatchingResult.setMatched(Integer.valueOf(1));
        resp.getSummaries().add(taxAmtMatchingResult);
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u540d\u79f0", (Object)bill.getInvoceName(), (Object)invoice.getName()));
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Object)bill.getTaxNo(), (Object)invoice.getTaxNo()));
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u5730\u5740", (Object)bill.getAddr(), (Object)invoice.getAddress()));
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u7535\u8bdd", (Object)bill.getPhone(), (Object)invoice.getPhone()));
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u5f00\u6237\u884c", (Object)bill.getBankName(), (Object)invoice.getBankName()));
        resp.getSummaries().add(new BillNotificationMatchingResult().compare("\u8d26\u6237", (Object)bill.getBankAccNo(), (Object)invoice.getBankAcNo()));
        for (BillNotificationMatchingResult result : resp.getSummaries()) {
            if (!new Integer(0).equals(result.getMatched())) continue;
            resp.setVerifyResult(Integer.valueOf(0));
        }
    }

    private void ascSortForNotificationNoList(List<BusiQueryInvoiceVerifyDetailRspBO> sortList) {
        Collections.sort(sortList, new Comparator<BusiQueryInvoiceVerifyDetailRspBO>(){

            @Override
            public int compare(BusiQueryInvoiceVerifyDetailRspBO arg0, BusiQueryInvoiceVerifyDetailRspBO arg1) {
                return arg0.getNotificationNo().compareTo(arg1.getNotificationNo());
            }
        });
    }
}

