/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiNotificationSplitService;
import com.tydic.fsc.settle.busi.api.BusiQueryNotificationSplitResultService;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationExReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationNoSplitGroupBO;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationOrderGroupBO;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationPurchaseUnitGroupBO;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationSplitGroupRspBO;
import com.tydic.fsc.settle.busi.api.vo.OrderInfoVO;
import com.tydic.fsc.settle.busi.api.vo.OrderItemVO;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.dao.vo.QueryReconcilitionOrderVO;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.PurchaseSaleType;
import com.tydic.fsc.settle.enums.ReconciliationStatus;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQueryNotificationSplitResultServiceImpl
implements BusiQueryNotificationSplitResultService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryNotificationSplitResultServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private BusiNotificationSplitService busiNotificationSplitService;

    public BusiNotificationSplitGroupRspBO querySplitResult(BusiNotificationExReqBO busiNotificationExReqBO) {
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u62c6\u5206\u7ed3\u679c\u67e5\u8be2\u5165\u53c2:" + busiNotificationExReqBO);
        }
        List<Object> orderInfos = new LinkedList();
        String groupWay = "";
        if (null != busiNotificationExReqBO.getVersionNo()) {
            QueryReconcilitionOrderVO queryReconcilitionOrderVO = new QueryReconcilitionOrderVO();
            queryReconcilitionOrderVO.setVersionNo(busiNotificationExReqBO.getVersionNo());
            queryReconcilitionOrderVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            queryReconcilitionOrderVO.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            queryReconcilitionOrderVO.setOrderBy("orderDate asc");
            queryReconcilitionOrderVO.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
            payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListByReconcilition(queryReconcilitionOrderVO);
            if (payPurchaseOrderInfoPOs.isEmpty()) {
                throw new BusinessException("1002", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
            }
            orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            groupWay = "noSplitGroup";
        } else {
            if (null == busiNotificationExReqBO.getSelectAllFlag()) {
                throw new BusinessException("1001", "\u662f\u5426\u5168\u9009\u6807\u8bc6[selectAllFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getOrderDateEnd()) {
                throw new BusinessException("1001", "\u7ed3\u675f\u65e5\u671f[orderDateEnd]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getCompanyId()) {
                throw new BusinessException("1001", "Session\u4e13\u4e1a\u516c\u53f8\u673a\u6784ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getGroupWay()) {
                throw new BusinessException("1001", "\u5206\u7ec4\u65b9\u5f0f[groupWay]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getMaxOrderNumber() || busiNotificationExReqBO.getMaxOrderNumber() <= 0) {
                throw new BusinessException("1001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u8ba2\u5355\u6570[maxOrderNumber]\u4e0d\u6b63\u786e");
            }
            if (null == busiNotificationExReqBO.getMaxOrderAmt()) {
                throw new BusinessException("1001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u91d1\u989d\u6570[maxOrderAmt]\u4e0d\u6b63\u786e");
            }
            groupWay = busiNotificationExReqBO.getGroupWay();
            if (!("noSplitGroup".equals(groupWay) || "purchaseUnitGroup".equals(groupWay) || "orderGroup".equals(groupWay))) {
                throw new BusinessException("1001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u6b63\u786e");
            }
            busiNotificationExReqBO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
            if (!"Y".equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag()) && !"N".equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag())) {
                throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5168\u9009\u6807\u8bc6[selectAllFlag]\u53ea\u80fd\u8f93\u5165Y\u6216N");
            }
            if ("Y".equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag())) {
                PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                payPurchaseOrderInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
                payPurchaseOrderInfoVO.setOperUnitNo(busiNotificationExReqBO.getCompanyId());
                payPurchaseOrderInfoVO.setPurchaseOrderCode(busiNotificationExReqBO.getPurchaseOrderCode());
                payPurchaseOrderInfoVO.setExtOrderId(busiNotificationExReqBO.getExtOrderId());
                payPurchaseOrderInfoVO.setSupplierNo(busiNotificationExReqBO.getSupplierNo());
                payPurchaseOrderInfoVO.setPurchaseNo(busiNotificationExReqBO.getPurchaseNo());
                payPurchaseOrderInfoVO.setOrderDateStart(busiNotificationExReqBO.getOrderDateStart());
                payPurchaseOrderInfoVO.setOrderDateEnd(busiNotificationExReqBO.getOrderDateEnd());
                payPurchaseOrderInfoVO.setRecvDateStart(busiNotificationExReqBO.getRecvDateStart());
                payPurchaseOrderInfoVO.setRecvDateEnd(busiNotificationExReqBO.getRecvDateEnd());
                payPurchaseOrderInfoVO.setReconcilitionStatus(busiNotificationExReqBO.getReconcilitionStatus());
                payPurchaseOrderInfoVO.setOrderBy("orderDate asc");
                payPurchaseOrderInfoVO.setPurchaseSaleType(busiNotificationExReqBO.getPurchaseSaleType());
                payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExt(payPurchaseOrderInfoVO);
                if (payPurchaseOrderInfoPOs.isEmpty()) {
                    throw new BusinessException("1002", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
                }
                orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            } else if ("N".equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag())) {
                if (null == busiNotificationExReqBO.getOrderInfos()) {
                    throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u975e\u5168\u9009\u65f6\uff0c\u8ba2\u5355\u5217\u8868\u4e0d\u5f97\u4e3a\u7a7a");
                }
                orderInfos = busiNotificationExReqBO.getOrderInfos();
            }
        }
        if (orderInfos == null || orderInfos.isEmpty()) {
            throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        List orderInfosList = null;
        Integer maxOrderNumber = busiNotificationExReqBO.getMaxOrderNumber();
        BigDecimal maxOrderAmt = new BigDecimal(busiNotificationExReqBO.getMaxOrderAmt());
        BusiNotificationSplitGroupRspBO busiNotificationSplitGroupRspBO = new BusiNotificationSplitGroupRspBO();
        if ("noSplitGroup".equals(groupWay)) {
            LinkedList<BusiNotificationNoSplitGroupBO> noSplitGroupBoList = new LinkedList<BusiNotificationNoSplitGroupBO>();
            orderInfosList = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, "noSplitGroup", maxOrderAmt);
            BusiNotificationNoSplitGroupBO busiNotificationNoSplitGroupBo = null;
            for (List list : orderInfosList) {
                busiNotificationNoSplitGroupBo = new BusiNotificationNoSplitGroupBO();
                HashSet<Long> purchaseUnitSet = new HashSet<Long>();
                BigDecimal sumAmt = BigDecimal.ZERO;
                for (OrderInfoVO orderInfoVO : list) {
                    sumAmt = sumAmt.add(orderInfoVO.getOrderAmt());
                    purchaseUnitSet.add(orderInfoVO.getPurchaseNo());
                }
                busiNotificationNoSplitGroupBo.setSupplierName(this.organizationInfoService.querySupplierName(((OrderInfoVO)list.get(0)).getSupplierNo()));
                busiNotificationNoSplitGroupBo.setPurchaseUnitCount(Integer.valueOf(purchaseUnitSet.size()));
                busiNotificationNoSplitGroupBo.setOrderCount(Integer.valueOf(list.size()));
                busiNotificationNoSplitGroupBo.setOrderAmt(sumAmt);
                noSplitGroupBoList.add(busiNotificationNoSplitGroupBo);
            }
            busiNotificationSplitGroupRspBO.setNoSplitGroupBoList(noSplitGroupBoList);
            busiNotificationSplitGroupRspBO.setOrderCount(Integer.valueOf(noSplitGroupBoList.size()));
        } else if ("purchaseUnitGroup".equals(groupWay)) {
            LinkedList<BusiNotificationPurchaseUnitGroupBO> purchaseUnitGroupBoList = new LinkedList<BusiNotificationPurchaseUnitGroupBO>();
            orderInfosList = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, "purchaseUnitGroup", maxOrderAmt);
            BusiNotificationPurchaseUnitGroupBO busiNotificationPurchaseUnitGroupBo = null;
            for (List list : orderInfosList) {
                busiNotificationPurchaseUnitGroupBo = new BusiNotificationPurchaseUnitGroupBO();
                busiNotificationPurchaseUnitGroupBo.setSupplierName(this.organizationInfoService.querySupplierName(((OrderInfoVO)list.get(0)).getSupplierNo()));
                busiNotificationPurchaseUnitGroupBo.setPurchaseUnitName(this.organizationInfoService.queryProjectName(((OrderInfoVO)list.get(0)).getPurchaseProjectId()));
                busiNotificationPurchaseUnitGroupBo.setOrderCount(Integer.valueOf(list.size()));
                BigDecimal sumAmt = BigDecimal.ZERO;
                for (OrderInfoVO orderInfoVO : list) {
                    sumAmt = sumAmt.add(orderInfoVO.getOrderAmt());
                }
                busiNotificationPurchaseUnitGroupBo.setOrderAmt(sumAmt);
                purchaseUnitGroupBoList.add(busiNotificationPurchaseUnitGroupBo);
            }
            busiNotificationSplitGroupRspBO.setPurchaseUnitGroupBoList(purchaseUnitGroupBoList);
            busiNotificationSplitGroupRspBO.setOrderCount(Integer.valueOf(purchaseUnitGroupBoList.size()));
        } else if ("orderGroup".equals(groupWay)) {
            LinkedList<BusiNotificationOrderGroupBO> orderGroupBoList = new LinkedList<BusiNotificationOrderGroupBO>();
            orderInfosList = this.busiNotificationSplitService.getSplitResult(orderInfos, null, "orderGroup", maxOrderAmt);
            BusiNotificationOrderGroupBO busiNotificationOrderGroupBo = null;
            for (List list : orderInfosList) {
                busiNotificationOrderGroupBo = new BusiNotificationOrderGroupBO();
                busiNotificationOrderGroupBo.setSupplierName(this.organizationInfoService.querySupplierName(((OrderInfoVO)list.get(0)).getSupplierNo()));
                busiNotificationOrderGroupBo.setPurchaseUnitName(this.organizationInfoService.queryOrgName(((OrderInfoVO)list.get(0)).getPurchaseNo()));
                busiNotificationOrderGroupBo.setPurchaseOrderCode(Long.valueOf(Long.parseLong(((OrderInfoVO)list.get(0)).getPurchaseOrderCode())));
                busiNotificationOrderGroupBo.setOrderAmt(((OrderInfoVO)list.get(0)).getOrderAmt());
                orderGroupBoList.add(busiNotificationOrderGroupBo);
            }
            busiNotificationSplitGroupRspBO.setOrderGroupBoList(orderGroupBoList);
            busiNotificationSplitGroupRspBO.setOrderCount(Integer.valueOf(orderGroupBoList.size()));
        }
        return busiNotificationSplitGroupRspBO;
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        for (PayPurchaseOrderInfo singleInfo : orderInfos) {
            OrderInfoVO singleVO = new OrderInfoVO();
            singleVO.setConfirmDate(singleInfo.getRecvDate());
            singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
            singleVO.setLastConfirmDate(singleInfo.getRecvDate());
            singleVO.setOrderAmt(singleInfo.getOrderAmt());
            singleVO.setOrderCreateDate(singleInfo.getOrderDate());
            singleVO.setOrderCreator(singleInfo.getPurchaserName());
            singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
            singleVO.setExtOrderId(singleInfo.getExtOrderId());
            singleVO.setOrderStatus(singleInfo.getOrderStatus());
            singleVO.setOrderType(singleInfo.getOrderType());
            singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
            singleVO.setPurchaseProjectId(singleInfo.getPurchaseProjectId());
            singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
            singleVO.setSupplierNo(singleInfo.getSupplierNo());
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            payItemInfoVO.setInspectionId(singleInfo.getInspectionId());
            List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
            if (itemInfos.isEmpty()) {
                throw new BusinessException("1002", "\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getPurchaseOrderCode() + "\u6ca1\u6709\u5546\u54c1\u660e\u7ec6");
            }
            LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
            for (PayItemInfo itemInfo : itemInfos) {
                OrderItemVO vo = new OrderItemVO();
                vo.setItemName(itemInfo.getItemName());
                vo.setSpec(itemInfo.getSpec());
                vo.setModel(itemInfo.getModel());
                vo.setUnit(itemInfo.getUnitName());
                vo.setUnitId(itemInfo.getUnitId());
                vo.setQuantity(itemInfo.getQuantity());
                vo.setSalePrice(itemInfo.getPurchaseUnitPrice());
                vo.setSumTaxPrice(itemInfo.getUntaxAmt().add(itemInfo.getTaxAmt()));
                itemVOs.add(vo);
            }
            singleVO.setItemList(itemVOs);
            infos.add(singleVO);
        }
        return infos;
    }
}

