/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryOutstockTotalDetailService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockTotalDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockTotalDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockTotalDetailShowRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleOrderDetailInfoRspBO;
import com.tydic.fsc.settle.dao.OutstockDetailMapper;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.OutstockTotalMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.StocksDetailMapper;
import com.tydic.fsc.settle.dao.po.OutstockDetail;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import com.tydic.fsc.settle.dao.po.OutstockTotal;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.po.StocksDetail;
import com.tydic.fsc.settle.dao.vo.QueryOutstockInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.OrderSource;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutstockTotalDetailServiceImpl
implements BusiQueryOutstockTotalDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockTotalDetailServiceImpl.class);
    @Autowired
    private OutstockTotalMapper outstockTotalMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public BusiQueryOutstockTotalDetailRspBO queryListPage(BusiQueryOutstockTotalDetailReqBO reqBO) {
        logger.info("\u51fa\u5e93\u6c47\u603b\u5355\u8be6\u60c5\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO);
        if (!StringUtils.hasText((String)reqBO.getTotalNo())) {
            throw new BusinessException("1001", "\u6c47\u603b\u5355\u53f7[totalNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockTotalDetailRspBO rspBO = new BusiQueryOutstockTotalDetailRspBO();
        OutstockTotal outstockTotal = this.outstockTotalMapper.selectByPrimaryKey(reqBO.getTotalNo());
        if (outstockTotal == null) {
            logger.info("\u6839\u636e\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo() + "\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u6839\u636e\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo() + "\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)outstockTotal, (Object)rspBO);
        rspBO.setCompanyName(this.organizationInfoService.queryOrgName(outstockTotal.getOrgId()));
        rspBO.setUserName(this.userInfoService.queryUserNameByUserId(outstockTotal.getUserId()));
        rspBO.setSumAmt(outstockTotal.getUntaxAmt().add(outstockTotal.getTaxAmt()));
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<OutstockInfo> list = this.outstockInfoMapper.selectByConditions(reqBO.getTotalNo(), (Page<Map<String, Object>>)page);
        LinkedList<BusiQueryOutstockTotalDetailShowRspBO> showRspBOList = new LinkedList<BusiQueryOutstockTotalDetailShowRspBO>();
        for (OutstockInfo outstockInfo : list) {
            BigDecimal sum = BigDecimal.ZERO;
            HashSet<Long> seqSet = new HashSet<Long>();
            BusiQueryOutstockTotalDetailShowRspBO showRspBO = new BusiQueryOutstockTotalDetailShowRspBO();
            BeanUtils.copyProperties((Object)outstockInfo, (Object)showRspBO);
            showRspBO.setPurchaseName(this.organizationInfoService.queryOrgName(outstockInfo.getPurchaseNo()));
            List<OutstockDetail> list1 = this.outstockDetailMapper.selectByCondition(outstockInfo.getOutstockNo());
            for (OutstockDetail outstockDetail : list1) {
                StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getPurchaseItemNo());
                if (stocksDetail == null || stocksDetail.getUntaxAmt() == null || seqSet.contains(stocksDetail.getSeq())) continue;
                sum = sum.add(stocksDetail.getUntaxAmt());
                seqSet.add(stocksDetail.getSeq());
            }
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(outstockInfo.getSource())) {
                QueryOutstockInfoVO outstockVO = new QueryOutstockInfoVO();
                outstockVO.setOutstockNo(outstockInfo.getOutstockNo());
                List<Long> inspectionIds = this.outstockInfoMapper.selectInspectionIdsByCondition(outstockVO);
                if (!CollectionUtils.isEmpty(inspectionIds)) {
                    SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                    saleOrderInfoVO.setInspectionIdList(inspectionIds);
                    List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                    for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                        SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                        detailRspBO.setInspectionId(orderInfo.getInspectionId());
                        detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                        detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                        saleOrderDetailList.add(detailRspBO);
                    }
                }
            }
            showRspBO.setSaleOrderDetailList(saleOrderDetailList);
            showRspBO.setAmt(sum);
            showRspBOList.add(showRspBO);
        }
        rspBO.setRows(showRspBOList);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

