/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiRecAmtConfirmRefreshService;
import com.tydic.fsc.settle.busi.api.bo.BusiRecAmtConfirmRefreshReqBO;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.vo.RecAmtConfirmPagination;
import com.tydic.fsc.settle.enums.ReceiptStatus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiRecAmtConfirmRefreshServiceImpl
implements BusiRecAmtConfirmRefreshService {
    private static final Logger logger = LoggerFactory.getLogger(BusiRecAmtConfirmRefreshServiceImpl.class);
    @Resource
    private SequenceNoService recAmtConfirmSeqNoService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;

    public FscBaseRspBo process(BusiRecAmtConfirmRefreshReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5237\u65b0\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        List docNums = reqBO.getDocNums();
        Date createDateStart = reqBO.getCreateDateStart();
        Date createDateEnd = reqBO.getCreateDateEnd();
        if (CollectionUtils.isEmpty((Collection)docNums) && createDateStart == null && createDateEnd == null) {
            Calendar calendar = Calendar.getInstance();
            createDateEnd = calendar.getTime();
            calendar.add(5, -30);
            createDateStart = calendar.getTime();
        }
        RecAmtConfirmPagination vo = new RecAmtConfirmPagination();
        vo.setDocNums(docNums);
        vo.setCreateDateStart(createDateStart);
        vo.setCreateDateEnd(createDateEnd);
        ArrayList<String> receiptStatusNotIn = new ArrayList<String>();
        receiptStatusNotIn.add(ReceiptStatus.ALL_RECEIPT.getCode());
        vo.setReceiptStatusNotIn(receiptStatusNotIn);
        List<RecAmtConfirm> recAmtConfirms = this.recAmtConfirmMapper.selectByCondition(vo);
        if (!CollectionUtils.isEmpty(recAmtConfirms)) {
            docNums.clear();
            for (RecAmtConfirm recAmtConfirm : recAmtConfirms) {
                docNums.add(recAmtConfirm.getDocNum());
            }
            vo = new RecAmtConfirmPagination();
            vo.setDocNums(docNums);
            int count = this.recAmtConfirmMapper.refreshReceiptStatus(vo);
            logger.debug("\u66f4\u65b0\u6536\u6b3e\u5355\uff08\u7535\u5b50\u8d85\u5e02\uff09\u7b14\u6570\uff1a" + count);
            count = this.recAmtConfirmMapper.refreshReceiptStatusDlzq(vo);
            logger.debug("\u66f4\u65b0\u6536\u6b3e\u5355\uff08\u7535\u529b\u4e13\u533a\u3001\u8be2\u6bd4\u4ef7\u3001\u7164\u70ad\u4e13\u533a\uff09\u7b14\u6570\uff1a" + count);
        }
        return new FscBaseRspBo();
    }
}

