/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.busi.api.BusiSubAcctTransLogListService;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAcctTranLogListRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAcctTransLogReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAcctTransLogRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.AcctTranInfoMapper;
import com.tydic.fsc.settle.dao.bo.AcctTranInfoExt;
import com.tydic.fsc.settle.enums.BusinessType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiSubAcctTransLogListServiceImpl
implements BusiSubAcctTransLogListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSubAcctTransLogListServiceImpl.class);
    @Autowired
    private AcctTranInfoMapper mapper;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private SubAccountRespInitService respInitService;
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private EnumsService enumsService;

    public BusiSubAcctTranLogListRspBO list(BusiSubAcctTransLogReqBO busiSubAcctTransLogReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5b50\u8d26\u53f7\u4ea4\u6613\u5386\u53f2BO:" + busiSubAcctTransLogReqBO);
        }
        BusiSubAcctTranLogListRspBO resp = new BusiSubAcctTranLogListRspBO();
        String subAcctNo = busiSubAcctTransLogReqBO.getSubAcctNo();
        String orgName = null;
        if (!StringUtils.hasText((String)subAcctNo)) {
            throw new BusinessException("1001", "\u5b50\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (subAcctNo != null && subAcctNo.length() > 0) {
            SubAcctInfoExt actInfoExt = this.subAccountService.getWithMainAccount(subAcctNo);
            if (actInfoExt == null) {
                throw new BusinessException("1001", "\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            BusiSubAccountInfoRspBO bo = new BusiSubAccountInfoRspBO();
            resp.setSubAcctInfo(bo);
            this.respInitService.initRespBo(actInfoExt, bo);
            orgName = bo.getAcctOrgName();
        }
        AcctTranInfoExt extInfo = new AcctTranInfoExt();
        BeanUtils.copyProperties((Object)busiSubAcctTransLogReqBO, (Object)extInfo);
        Page page = new Page(busiSubAcctTransLogReqBO.getPageNo(), busiSubAcctTransLogReqBO.getPageSize());
        List<AcctTranInfoExt> ls = this.mapper.unionQuery(extInfo, (Page<Map<String, Object>>)page);
        resp.setRecordsTotal(page.getTotalCount());
        resp.setTotal(page.getTotalPages());
        resp.setPageNo(page.getPageNo());
        resp.setRows(new ArrayList());
        for (int i = 0; i < ls.size(); ++i) {
            AcctTranInfoExt inf = ls.get(i);
            BusiSubAcctTransLogRspBO respBo = new BusiSubAcctTransLogRspBO();
            resp.getRows().add(respBo);
            BeanUtils.copyProperties((Object)inf, (Object)respBo);
            if (orgName != null) {
                respBo.setOrgName(orgName);
            } else {
                String name = this.orgService.queryOrgName(respBo.getOrgId());
                respBo.setOrgName(name);
            }
            BusinessType busiType = BusinessType.getInstance(inf.getBusinessType());
            respBo.setBusinessTypeDescr(this.enumsService.getDescr(busiType));
            if (!StringUtils.hasText((String)respBo.getServiceNo())) {
                respBo.setServiceNo("" + respBo.getSeq());
            }
            if (respBo.getTranAmt() == null || !"DR".equals(inf.getDrcrFlag())) continue;
            respBo.setTranAmt(respBo.getTranAmt().negate());
        }
        return resp;
    }
}

