/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.WFPayStartBusiService;
import com.tydic.fsc.settle.atom.bo.PayStartBusiReqBO;
import com.tydic.fsc.settle.atom.bo.PayStartBusiRspBO;
import com.tydic.fsc.settle.busi.api.BusiSummaryTheMonthPayIncomeCalc;
import com.tydic.fsc.settle.busi.api.bo.BusiSummaryTheMonthPayIncomeCalcReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSummaryTheMonthPayIncomeCalcRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.IncomeCalcMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.IncomeCalc;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.RedBlue;
import com.tydic.fsc.settle.enums.WFBillType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiSummaryTheMonthPayIncomeCalcImpl
implements BusiSummaryTheMonthPayIncomeCalc {
    private static final Logger logger = LoggerFactory.getLogger(BusiSummaryTheMonthPayIncomeCalcImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private WFPayStartBusiService wfPayStartBusiService;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private IncomeCalcMapper incomeCalcMapper;

    public BusiSummaryTheMonthPayIncomeCalcRspBO processSummary(BusiSummaryTheMonthPayIncomeCalcReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6c47\u603b\u5f53\u6708\u6536\u5165\u8ba1\u7b97\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String payFeeType = reqBO.getPayFeeType();
        if (!StringUtils.hasText((String)payFeeType)) {
            throw new BusinessException("1001", "\u652f\u4ed8\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
            for (String applyNo : reqBO.getApplyNoList()) {
                BillApplyInfo applyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
                if (null != applyInfo && StringUtils.hasText((String)applyInfo.getBillNo())) {
                    throw new BusinessException("1001", "\u5f00\u7968\u7533\u8bf7\u5355" + applyNo + "\u5df2\u6c47\u603b,\u8bf7\u52fe\u9009\u672a\u6c47\u603b\u7684\u6570\u636e");
                }
                if (null == applyInfo || BillStatus.SEND_BILL.getCode().equals(applyInfo.getBillStatus())) continue;
                throw new BusinessException("1001", "\u5f00\u7968\u7533\u8bf7\u5355" + applyNo + "\u5f00\u7968\u72b6\u6001\u4e0d\u662f\u5df2\u5f00\u7968,\u8bf7\u52fe\u9009\u5df2\u5f00\u7968\u7684\u6570\u636e");
            }
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(reqBO.getApplyNoList());
        billApplyInfoVO.setOperUnitNo(reqBO.getCompanyId());
        billApplyInfoVO.setBillStatus(BillStatus.SEND_BILL.getCode());
        billApplyInfoVO.setTheYear(reqBO.getTheYear());
        billApplyInfoVO.setTheMonth(reqBO.getTheMonth());
        if (InquiryPayFeeType.PLAT_USE_FEE.getCode().equals(payFeeType)) {
            billApplyInfoVO.setPayFeeType(InquiryPayFeeType.PLAT_USE_FEE.getCode());
            List<BillApplyInfo> applys = this.billApplyInfoMapper.getTheMonthBillApplyInfoList(billApplyInfoVO);
            LinkedList<BillApplyInfo> paperNormalInvoiceList = new LinkedList<BillApplyInfo>();
            LinkedList<BillApplyInfo> paperRedInvoiceList = new LinkedList<BillApplyInfo>();
            LinkedList<BillApplyInfo> electronicNormalInvoiceList = new LinkedList<BillApplyInfo>();
            LinkedList<BillApplyInfo> electronicRedInvoiceList = new LinkedList<BillApplyInfo>();
            for (BillApplyInfo billApplyInfo : applys) {
                String invoiceClasses = billApplyInfo.getInvoiceClasses();
                String redBlue = billApplyInfo.getRedBlue();
                if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses) && RedBlue.BLUE.getCode().equals(redBlue)) {
                    paperNormalInvoiceList.add(billApplyInfo);
                    continue;
                }
                if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses) && RedBlue.RED.getCode().equals(redBlue)) {
                    paperRedInvoiceList.add(billApplyInfo);
                    continue;
                }
                if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses) && RedBlue.BLUE.getCode().equals(redBlue)) {
                    electronicNormalInvoiceList.add(billApplyInfo);
                    continue;
                }
                if (!InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses) || !RedBlue.RED.getCode().equals(redBlue)) continue;
                electronicRedInvoiceList.add(billApplyInfo);
            }
            this.summaryBillApplyInfo(paperNormalInvoiceList, reqBO.getUserId());
            this.summaryBillApplyInfo(paperRedInvoiceList, reqBO.getUserId());
            this.summaryBillApplyInfo(electronicNormalInvoiceList, reqBO.getUserId());
            this.summaryBillApplyInfo(electronicRedInvoiceList, reqBO.getUserId());
        } else if (InquiryPayFeeType.TRADE_SERVICE_FEE.getCode().equals(payFeeType)) {
            ArrayList<String> payFeeTypeList = new ArrayList<String>();
            payFeeTypeList.add(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
            payFeeTypeList.add(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode());
            billApplyInfoVO.setPayFeeTypeList(payFeeTypeList);
            List<BillApplyInfo> applys = this.billApplyInfoMapper.getTheMonthBillApplyInfoList(billApplyInfoVO);
            this.summaryBillApplyInfo(applys, reqBO.getUserId());
        }
        BusiSummaryTheMonthPayIncomeCalcRspBO rspBO = new BusiSummaryTheMonthPayIncomeCalcRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void summaryBillApplyInfo(List<BillApplyInfo> billApplyInfoList, Long userId) {
        BillApplyInfo billApplyInfo2;
        if (CollectionUtils.isEmpty(billApplyInfoList)) {
            return;
        }
        String billNo = this.billSNService.getSnAsString(BillType.INCOME_CALC);
        HashSet<String> applyNoSet = new HashSet<String>();
        for (BillApplyInfo billApplyInfo2 : billApplyInfoList) {
            applyNoSet.add(billApplyInfo2.getApplyNo());
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(new ArrayList<String>(applyNoSet));
        billApplyInfo2 = new BillApplyInfo();
        billApplyInfo2.setBillNo(billNo);
        this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo2);
        IncomeCalc incomeCalc = new IncomeCalc();
        incomeCalc.setBillNo(billNo);
        incomeCalc.setCreateUser(userId);
        this.incomeCalcMapper.insert(incomeCalc);
        PayStartBusiReqBO req = new PayStartBusiReqBO();
        req.setUserId(userId);
        req.setBillNo(billNo);
        String redBlue = billApplyInfoList.get(0).getRedBlue();
        if (RedBlue.BLUE.getCode().equals(redBlue)) {
            req.setBillType(WFBillType.SUPPLIER_PAY_INCOME_CALC);
        } else if (RedBlue.RED.getCode().equals(redBlue)) {
            req.setBillType(WFBillType.SUPPLIER_PAY_INCOME_RED_CALC);
        } else {
            req.setBillType(WFBillType.SUPPLIER_PAY_INCOME_CALC);
        }
        req.setFinishEvtServiceId("supplierPayIncomeCalcWorkFlowFinishEventImpl");
        PayStartBusiRspBO rspBO = null;
        try {
            rspBO = this.wfPayStartBusiService.addApproveFlow(req);
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25\u3002\u5165\u53c2=" + req, (Throwable)e);
            throw new BusinessException("1002", "\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25");
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            logger.error("\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25\u3002\u5165\u53c2=" + req);
            throw new BusinessException("1002", "\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25");
        }
    }
}

