/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.DzcsQrySaleInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.DzcsQrySaleInvoiceDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsQrySaleInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsQrySaleInvoiceRspBO;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.RedBlue;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsQrySaleInvoiceServiceImpl
implements DzcsQrySaleInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsQrySaleInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public DzcsQrySaleInvoiceRspBO query(DzcsQrySaleInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u67e5\u8be2\u53d1\u7968\u670d\u52a1(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("1001", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && null == reqBO.getPurchaseProjectId()) {
            throw new BusinessException("1001", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        if ("1".equals(reqBO.getIsOperUnit())) {
            saleInvoiceInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)saleInvoiceInfoVO);
        List<SaleInvoiceInfoVO> saleInvoiceList = this.saleInvoiceInfoMapper.selectInvoiceAndBillInfoPage(saleInvoiceInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<DzcsQrySaleInvoiceDetailRspBO> rows = new ArrayList<DzcsQrySaleInvoiceDetailRspBO>();
        for (SaleInvoiceInfoVO saleInvoice : saleInvoiceList) {
            DzcsQrySaleInvoiceDetailRspBO row = new DzcsQrySaleInvoiceDetailRspBO();
            BeanUtils.copyProperties((Object)saleInvoice, (Object)row);
            row.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(saleInvoice.getInvoiceType()))));
            row.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(saleInvoice.getInvoiceClasses())));
            if (!StringUtils.hasText((String)saleInvoice.getRedBlue())) {
                saleInvoice.setRedBlue(RedBlue.BLUE.getCode());
            }
            row.setRedBlueDescr(this.enumsService.getDescr((BaseEnums)RedBlue.convert((String)saleInvoice.getRedBlue())));
            row.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoice.getInvoiceStatus())));
            rows.add(row);
        }
        DzcsQrySaleInvoiceRspBO rspBO = new DzcsQrySaleInvoiceRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

