/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.FscCancelReceiptConfirmAtomService;
import com.tydic.fsc.settle.atom.FscCancelSupPayReceiptOrderAtomService;
import com.tydic.fsc.settle.atom.bo.BusiCancelSupplierPayIncomeCalcReqBO;
import com.tydic.fsc.settle.atom.bo.FscCancelReceiptConfirmAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscCancelReceiptConfirmAtomRspBO;
import com.tydic.fsc.settle.atom.bo.FscCancelSupPayReceiptOrderAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscCancelSupPayReceiptOrderAtomRspBO;
import com.tydic.fsc.settle.atom.impl.BusiCancelSupplierPayIncomeCalcService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiCancelApplyPayService;
import com.tydic.fsc.settle.busi.api.BusiCancelEntryTotalInfoService;
import com.tydic.fsc.settle.busi.api.BusiCancelOutstockTotalService;
import com.tydic.fsc.settle.busi.api.FscWfFinishTaskBusiService;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelApplyPayReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelEntryTotalInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelOutstockTotalReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscWfFinishTaskBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscWfFinishTaskBusiRspBO;
import com.tydic.fsc.settle.constants.FscCommonConstants;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.enums.FinancialStatus;
import com.tydic.fsc.settle.enums.WFBillType;
import com.tydic.fsc.settle.enums.WFStatus;
import com.tydic.fsc.settle.utils.FscCommonUtils;
import com.tydic.uac.ability.UocAuditObjectAuditCombService;
import com.tydic.uac.ability.bo.UocAuditObjectAuditCombReqBO;
import com.tydic.uac.ability.bo.UocAuditObjectAuditCombRspBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscWfFinishTaskBusiService")
public class FscWfFinishTaskBusiServiceImpl
implements FscWfFinishTaskBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfFinishTaskBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String APPROVAL_SUCCESS = "1";
    private WorkFlowDataMapper workFlowDataMapper;
    private UocAuditObjectAuditCombService uocAuditObjectAuditCombService;
    private FscCancelSupPayReceiptOrderAtomService fscCancelSupPayReceiptOrderAtomService;
    private BusiCancelEntryTotalInfoService busiCancelEntryTotalInfoService;
    private BusiCancelOutstockTotalService busiCancelOutstockTotalService;
    private FscCancelReceiptConfirmAtomService fscCancelReceiptConfirmAtomService;
    private BusiCancelSupplierPayIncomeCalcService busiCancelSupplierPayIncomeCalcService;
    private BusiCancelApplyPayService busiCancelApplyPayService;

    @Autowired
    private FscWfFinishTaskBusiServiceImpl(WorkFlowDataMapper workFlowDataMapper, UocAuditObjectAuditCombService uocAuditObjectAuditCombService, FscCancelSupPayReceiptOrderAtomService fscCancelSupPayReceiptOrderAtomService, BusiCancelEntryTotalInfoService busiCancelEntryTotalInfoService, BusiCancelOutstockTotalService busiCancelOutstockTotalService, FscCancelReceiptConfirmAtomService fscCancelReceiptConfirmAtomService, BusiCancelSupplierPayIncomeCalcService busiCancelSupplierPayIncomeCalcService, BusiCancelApplyPayService busiCancelApplyPayService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.uocAuditObjectAuditCombService = uocAuditObjectAuditCombService;
        this.fscCancelSupPayReceiptOrderAtomService = fscCancelSupPayReceiptOrderAtomService;
        this.busiCancelEntryTotalInfoService = busiCancelEntryTotalInfoService;
        this.busiCancelOutstockTotalService = busiCancelOutstockTotalService;
        this.fscCancelReceiptConfirmAtomService = fscCancelReceiptConfirmAtomService;
        this.busiCancelSupplierPayIncomeCalcService = busiCancelSupplierPayIncomeCalcService;
        this.busiCancelApplyPayService = busiCancelApplyPayService;
    }

    public FscWfFinishTaskBusiRspBO dealFinishTask(FscWfFinishTaskBusiReqBO reqBO) {
        FscWfFinishTaskBusiRspBO rspBO = new FscWfFinishTaskBusiRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        String procInstId = reqBO.getProcInstId();
        if (!APPROVAL_SUCCESS.equals(reqBO.getSeqFlowId())) {
            this.cancelOrder(procInstId);
        }
        UocAuditObjectAuditCombReqBO auditObjectAuditCombReqBO = new UocAuditObjectAuditCombReqBO();
        auditObjectAuditCombReqBO.setOrderId(Long.valueOf(procInstId));
        auditObjectAuditCombReqBO.setAuditAdvice(reqBO.getComment());
        auditObjectAuditCombReqBO.setAuditResult(APPROVAL_SUCCESS.equals(reqBO.getSeqFlowId()) ? "0" : APPROVAL_SUCCESS);
        auditObjectAuditCombReqBO.setOperId(FscCommonUtils.long2String((Long)reqBO.getUserId()));
        UocAuditObjectAuditCombRspBO auditObjectAuditCombRspBO = this.uocAuditObjectAuditCombService.dealObjectAudit(auditObjectAuditCombReqBO);
        if (!"0000".equals(auditObjectAuditCombRspBO.getRespCode()) || null == auditObjectAuditCombRspBO.getApprovalObjInfo()) {
            LOGGER.error("procInstId=[" + procInstId + "],\u5ba1\u6279\u63d0\u4ea4\u5904\u7406\u670d\u52a1\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u670d\u52a1\u5f02\u5e38");
            throw new BusinessException("6003", "\u5ba1\u6279\u63d0\u4ea4\u5904\u7406\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u670d\u52a1\u5f02\u5e38" + auditObjectAuditCombRspBO.getRespDesc());
        }
        WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
        workFlowDataInfo.setProcInstId(procInstId);
        workFlowDataInfo.setReceiveDate(new Date());
        workFlowDataInfo.setLastOperator(reqBO.getUserId());
        if (UacCommConstant.STATUS.REVIEW_COMPLETED.equals(auditObjectAuditCombRspBO.getApprovalObjInfo().getStatus())) {
            workFlowDataInfo.setFinancialStatus(FinancialStatus.NO_SEND.getCode());
            workFlowDataInfo.setTryCount(FscCommonConstants.APPROVAL_TRY_COUNT);
            if (APPROVAL_SUCCESS.equals(reqBO.getSeqFlowId())) {
                workFlowDataInfo.setStatus(WFStatus.APPROVAL_COMPLETE.getCode());
            } else {
                workFlowDataInfo.setStatus(WFStatus.REJECTED.getCode());
            }
            rspBO.setWfFinish(Boolean.valueOf(true));
        } else {
            rspBO.setWfFinish(Boolean.valueOf(false));
        }
        int result = this.workFlowDataMapper.updateByPrimaryKey(workFlowDataInfo);
        if (result < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("procInstId=[" + procInstId + "],\u66f4\u65b0workflow_data\u8868\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6003", "\u66f4\u65b0\u5ba1\u6279\u8bb0\u5f55\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u63d0\u4ea4\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void cancelOrder(String procInstId) {
        WorkFlowDataInfo workFlowData = new WorkFlowDataInfo();
        workFlowData.setProcInstId(procInstId);
        workFlowData = this.workFlowDataMapper.getModelBy(workFlowData);
        if (WFBillType.COLLECTION_CONFIRMATION.getCode().equals(workFlowData.getBillType())) {
            FscCancelReceiptConfirmAtomReqBO cancelReceiptConfirmAtomReqBO = new FscCancelReceiptConfirmAtomReqBO();
            cancelReceiptConfirmAtomReqBO.setDocNum(Long.valueOf(workFlowData.getBillNo()));
            FscCancelReceiptConfirmAtomRspBO cancelReceiptConfirmAtomRspBO = this.fscCancelReceiptConfirmAtomService.cancelReceiptConfirm(cancelReceiptConfirmAtomReqBO);
            if (!"0000".equals(cancelReceiptConfirmAtomRspBO.getRespCode())) {
                throw new BusinessException("6003", "\u5ba1\u6279\u9a73\u56de\u65f6\uff0c\u64a4\u9500\u5355\u636e\u5931\u8d25" + cancelReceiptConfirmAtomRspBO.getRespDesc());
            }
        } else if (WFBillType.PAY_APPLICATION.getCode().equals(workFlowData.getBillType())) {
            BusiCancelApplyPayReqBO busiCancelApplyPayReqBO = new BusiCancelApplyPayReqBO();
            busiCancelApplyPayReqBO.setDocNum(Long.valueOf(workFlowData.getBillNo()));
            FscBaseRspBo baseRspBo = this.busiCancelApplyPayService.cancelApplyPay(busiCancelApplyPayReqBO);
            if (!"0000".equals(baseRspBo.getRespCode())) {
                throw new BusinessException("6003", "\u5ba1\u6279\u9a73\u56de\u65f6\uff0c\u64a4\u9500\u5355\u636e\u5931\u8d25" + baseRspBo.getRespDesc());
            }
        } else if (WFBillType.PURCHASE_STORAGE.getCode().equals(workFlowData.getBillType())) {
            BusiCancelEntryTotalInfoReqBO busiCancelEntryTotalInfoReqBO = new BusiCancelEntryTotalInfoReqBO();
            busiCancelEntryTotalInfoReqBO.setDocNum(workFlowData.getBillNo());
            FscBaseRspBo baseRspBo = this.busiCancelEntryTotalInfoService.cancelEntryTotalInfo(busiCancelEntryTotalInfoReqBO);
            if (!"0000".equals(baseRspBo.getRespCode())) {
                throw new BusinessException("6003", "\u5ba1\u6279\u9a73\u56de\u65f6\uff0c\u64a4\u9500\u5355\u636e\u5931\u8d25" + baseRspBo.getRespDesc());
            }
        } else if (WFBillType.OUTBOUND_COLLECTION.getCode().equals(workFlowData.getBillType())) {
            BusiCancelOutstockTotalReqBO busiCancelOutstockTotalReqBO = new BusiCancelOutstockTotalReqBO();
            busiCancelOutstockTotalReqBO.setDocNum(workFlowData.getBillNo());
            FscBaseRspBo baseRspBo = this.busiCancelOutstockTotalService.cancelOutstockTotal(busiCancelOutstockTotalReqBO);
            if (!"0000".equals(baseRspBo.getRespCode())) {
                throw new BusinessException("6003", "\u5ba1\u6279\u9a73\u56de\u65f6\uff0c\u64a4\u9500\u5355\u636e\u5931\u8d25" + baseRspBo.getRespDesc());
            }
        } else if (WFBillType.SUPPLIER_PAY_COLLECTION_CONFIRMATION.getCode().equals(workFlowData.getBillType())) {
            FscCancelSupPayReceiptOrderAtomReqBO cancelSupPayReceiptOrderAtomReqBO = new FscCancelSupPayReceiptOrderAtomReqBO();
            cancelSupPayReceiptOrderAtomReqBO.setDocNum(Long.valueOf(workFlowData.getBillNo()));
            FscCancelSupPayReceiptOrderAtomRspBO cancelSupPayReceiptOrderAtomRspBO = this.fscCancelSupPayReceiptOrderAtomService.cancelSupPayReceiptOrder(cancelSupPayReceiptOrderAtomReqBO);
            if (!"0000".equals(cancelSupPayReceiptOrderAtomRspBO.getRespCode())) {
                throw new BusinessException("6003", "\u5ba1\u6279\u9a73\u56de\u65f6\uff0c\u64a4\u9500\u5355\u636e\u5931\u8d25" + cancelSupPayReceiptOrderAtomRspBO.getRespDesc());
            }
        } else if (WFBillType.SUPPLIER_PAY_INCOME_CALC.getCode().equals(workFlowData.getBillType())) {
            BusiCancelSupplierPayIncomeCalcReqBO payIncomeCalcReqBO = new BusiCancelSupplierPayIncomeCalcReqBO();
            payIncomeCalcReqBO.setDocNum(workFlowData.getBillNo());
            FscBaseRspBo baseRspBo = this.busiCancelSupplierPayIncomeCalcService.cancelSupplierPayIncomeCalc(payIncomeCalcReqBO);
            if (!"0000".equals(baseRspBo.getRespCode())) {
                throw new BusinessException("6003", "\u5ba1\u6279\u9a73\u56de\u65f6\uff0c\u64a4\u9500\u5355\u636e\u5931\u8d25" + baseRspBo.getRespDesc());
            }
        }
    }

    private String validateArg(FscWfFinishTaskBusiReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getSeqFlowId())) {
            return "\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getProcInstId()) {
            return "\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

