/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.InvoiceReturnApplyBlueInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnApplyBlueInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnApplyBlueInvoiceRspBO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceHeaderXbjVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceMailAddrInfoXbjVO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.RedBlue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnApplyBlueInvoiceServiceImpl
implements InvoiceReturnApplyBlueInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnApplyBlueInvoiceServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public InvoiceReturnApplyBlueInvoiceRspBO process(InvoiceReturnApplyBlueInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        String billNo = reqBO.getBillNo();
        InvoiceHeaderXbjVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoXbjVO mailAddrInfo = reqBO.getMailAddrInfo();
        String invoiceType = reqBO.getInvoiceType();
        String invoiceClasses = reqBO.getInvoiceClasses();
        String receiveInvoicePhone = reqBO.getReceiveInvoicePhone();
        String receiveInvoiceEmail = reqBO.getReceiveInvoiceEmail();
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("1001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!InvoiceType.NORMAL.getCode().toString().equals(invoiceType) && !InvoiceType.SPECIAL.getCode().toString().equals(invoiceType)) {
            throw new BusinessException("1001", "\u53d1\u7968\u7c7b\u578b\u9519\u8bef");
        }
        if (!InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses) && !InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses)) {
            throw new BusinessException("1001", "\u53d1\u7968\u7c7b\u522b\u9519\u8bef");
        }
        if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses) && InvoiceType.SPECIAL.getCode().toString().equals(invoiceType)) {
            throw new BusinessException("1001", "\u7535\u5b50\u53d1\u7968\u4e0d\u80fd\u5f00\u4e13\u7968");
        }
        if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses) && !StringUtils.hasText((String)receiveInvoicePhone) && !StringUtils.hasText((String)receiveInvoiceEmail)) {
            throw new BusinessException("1001", "\u7533\u8bf7\u7535\u5b50\u53d1\u7968\u65f6\uff0c\u624b\u673a\u53f7\u548c\u90ae\u7bb1\u81f3\u5c11\u586b\u5199\u4e00\u9879");
        }
        if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses) && mailAddrInfo == null) {
            throw new BusinessException("1001", "\u7533\u8bf7\u7eb8\u8d28\u53d1\u7968\u65f6\uff0c\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceInfo == null) {
            throw new BusinessException("1001", "\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billNo);
        List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
        if (!InvoiceReturnStatus.RETURNED.getCode().equals(invoiceReturn.getStatus())) {
            throw new BusinessException("1001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.RETURNED));
        }
        HashMap applyNo1Map = new HashMap();
        for (InvoiceReturnDetail invoiceReturnDetail : details) {
            if (applyNo1Map.containsKey(invoiceReturnDetail.getApplyNo1())) {
                ((List)applyNo1Map.get(invoiceReturnDetail.getApplyNo1())).add(invoiceReturnDetail.getInvoiceNo1());
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(invoiceReturnDetail.getInvoiceNo1());
            applyNo1Map.put(invoiceReturnDetail.getApplyNo1(), arrayList);
        }
        ArrayList<String> applyNo3s = new ArrayList<String>();
        for (Map.Entry entry : applyNo1Map.entrySet()) {
            String applyNo1 = (String)entry.getKey();
            List invoiceNo1s = (List)entry.getValue();
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo1);
            saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
            List<SaleInvoiceInfo> invoice1s = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            if (invoice1s.size() != invoiceNo1s.size()) {
                throw new BusinessException("1001", "\u539f\u53d1\u7968\u6570\u636e\u6709\u8bef");
            }
            BigDecimal amt = BigDecimal.ZERO;
            for (SaleInvoiceInfo invoice1 : invoice1s) {
                amt = amt.add(invoice1.getAmt());
            }
            BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
            String applyNo3 = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
            BillApplyInfo billApplyInfo3 = new BillApplyInfo();
            billApplyInfo3.setApplyNo(applyNo3);
            billApplyInfo3.setApplyDate(new Date());
            billApplyInfo3.setReturnBillNo(billNo);
            billApplyInfo3.setRedBlue(RedBlue.BLUE.getCode());
            billApplyInfo3.setAmt(amt);
            billApplyInfo3.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo3.setUserId(reqBO.getUserId());
            billApplyInfo3.setSource(billApplyInfo1.getSource());
            billApplyInfo3.setApplyType(billApplyInfo1.getApplyType());
            billApplyInfo3.setSupplierNo(billApplyInfo1.getSupplierNo());
            billApplyInfo3.setSupplierName(billApplyInfo1.getSupplierName());
            billApplyInfo3.setOperUnitNo(billApplyInfo1.getOperUnitNo());
            billApplyInfo3.setOperUnitName(billApplyInfo1.getOperUnitName());
            billApplyInfo3.setPayFeeType(billApplyInfo1.getPayFeeType());
            billApplyInfo3.setInvoiceClasses(invoiceClasses);
            billApplyInfo3.setInvoiceType(invoiceType);
            billApplyInfo3.setInvoceName(invoiceInfo.getCompName());
            billApplyInfo3.setTaxNo(invoiceInfo.getNum());
            billApplyInfo3.setAddr(invoiceInfo.getAddress());
            billApplyInfo3.setPhone(invoiceInfo.getTel());
            billApplyInfo3.setBankName(invoiceInfo.getBankName());
            billApplyInfo3.setBankAcctNo(invoiceInfo.getBankAcct());
            if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) {
                billApplyInfo3.setName(mailAddrInfo.getName());
                billApplyInfo3.setProvince(mailAddrInfo.getProvinceName());
                billApplyInfo3.setCity(mailAddrInfo.getCityName());
                billApplyInfo3.setCounty(mailAddrInfo.getCountyName());
                billApplyInfo3.setTown(mailAddrInfo.getTown());
                billApplyInfo3.setProvId(mailAddrInfo.getProvId());
                billApplyInfo3.setCityId(mailAddrInfo.getCityId());
                billApplyInfo3.setCountyId(mailAddrInfo.getCountyId());
                billApplyInfo3.setTownId(mailAddrInfo.getTownId());
                billApplyInfo3.setAddrDesc(mailAddrInfo.getAddrDesc());
                billApplyInfo3.setMobile(mailAddrInfo.getTel());
                billApplyInfo3.setTel(mailAddrInfo.getSpecialPlane());
                billApplyInfo3.setPostCode(mailAddrInfo.getPostCode());
            } else {
                billApplyInfo3.setReceiveInvoicePhone(receiveInvoicePhone);
                billApplyInfo3.setReceiveInvoiceEmail(receiveInvoiceEmail);
            }
            this.billApplyInfoMapper.insert(billApplyInfo3);
            InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
            whereRecord.setBillNo(billNo);
            whereRecord.setApplyNo1(applyNo1);
            InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
            valueRecord.setApplyNo3(applyNo3);
            this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
            applyNo3s.add(applyNo3);
        }
        invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setStatus(InvoiceReturnStatus.TO_BILL.getCode());
        this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        InvoiceReturnApplyBlueInvoiceRspBO invoiceReturnApplyBlueInvoiceRspBO = new InvoiceReturnApplyBlueInvoiceRspBO();
        invoiceReturnApplyBlueInvoiceRspBO.setMsg("\u540e\u53f0\u751f\u6210" + applyNo3s.size() + "\u4e2a\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u548c\u539f\u5f00\u7968\u7533\u8bf7\u5355\u4e00\u4e00\u5bf9\u5e94\uff1a" + com.tydic.fsc.settle.utils.StringUtils.list2String(applyNo3s, "\uff0c"));
        return invoiceReturnApplyBlueInvoiceRspBO;
    }
}

