/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.InvoiceReturnUploadFileService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnUploadFileReqBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnUploadFileRspBO;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.enums.InvoiceReturnFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnUploadFileServiceImpl
implements InvoiceReturnUploadFileService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnUploadFileServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;

    public InvoiceReturnUploadFileRspBO process(InvoiceReturnUploadFileReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4e0a\u4f20\u9644\u4ef6\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        Boolean isUpdate = reqBO.getIsUpdate();
        String billNo = reqBO.getBillNo();
        Integer fileType = reqBO.getFileType();
        String originalFilename = reqBO.getOriginalFilename();
        if (isUpdate == null) {
            throw new BusinessException("1001", "isUpdate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("1001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileType == null) {
            throw new BusinessException("1001", "\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)originalFilename)) {
            throw new BusinessException("1001", "\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        Integer realFileType = InvoiceReturn.obtainRealFileType(fileType);
        if (originalFilename.indexOf(",") >= 0) {
            throw new BusinessException("1001", "\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u82f1\u6587\u9017\u53f7");
        }
        if (invoiceReturn.checkIsRepeat(originalFilename)) {
            throw new BusinessException("1001", "\u6587\u4ef6\u4e0d\u80fd\u91cd\u540d\uff0c\u8bf7\u5220\u9664\u539f\u6709\u6587\u4ef6\u6216\u8005\u91cd\u547d\u540d\u65b0\u6587\u4ef6");
        }
        if (isUpdate.booleanValue()) {
            InvoiceReturn invoiceReturnUpdate = new InvoiceReturn();
            invoiceReturnUpdate.setBillNo(billNo);
            if (InvoiceReturnFileType.LICENSE_FILE.getCode().equals(realFileType)) {
                invoiceReturnUpdate.setLicenseFile(originalFilename);
            } else if (InvoiceReturnFileType.BANK_LICENSE_FILE.getCode().equals(realFileType)) {
                invoiceReturnUpdate.setBankLicenseFile(originalFilename);
            } else if (InvoiceReturnFileType.APPLY_FILE.getCode().equals(realFileType)) {
                invoiceReturnUpdate.setApplyFile(originalFilename);
            } else if (InvoiceReturnFileType.REMARK_FILE.getCode().equals(realFileType)) {
                invoiceReturnUpdate.setRemarkFile(originalFilename);
            } else if (InvoiceReturnFileType.INVOICE_FILE.getCode().equals(realFileType)) {
                String invoiceFile = invoiceReturn.getInvoiceFile();
                invoiceFile = StringUtils.hasText((String)invoiceFile) ? invoiceFile + "," + originalFilename : originalFilename;
                invoiceReturnUpdate.setInvoiceFile(invoiceFile);
            }
            this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturnUpdate);
        }
        String ossFilename = invoiceReturn.obtainOssFilename(originalFilename);
        InvoiceReturnUploadFileRspBO rspBO = new InvoiceReturnUploadFileRspBO();
        rspBO.setOssFilename(ossFilename);
        return rspBO;
    }
}

