/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.PayNullifyOrderService;
import com.tydic.fsc.settle.busi.api.bo.PayNullifyOrderReqBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayNullifyOrderServiceImpl
implements PayNullifyOrderService {
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public FscBaseRspBo updateNullifyOrder(PayNullifyOrderReqBO reqBO) {
        String respCode = null;
        if (null == reqBO.getPayOrderNo()) {
            respCode = "6001";
            throw new BusinessException("1001", "\u5165\u53c2\u7f34\u8d39\u5355\u53f7[payOrderNo]\u4e3a\u7a7a!");
        }
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        payOrderInfoExt.setPayOrderNo(reqBO.getPayOrderNo());
        InquiryPayOrder inquiryPayOrder = this.inquiryPayOrderMapper.selectByPrimaryKey(payOrderInfoExt);
        if (InquiryPaymentStatus.IN_PAYMENT.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.ALREADY_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.REC_CONFIRMED.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
            respCode = "6002";
            throw new BusinessException("1002", "\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u6b63\u5728\u7f34\u8d39\u4e2d\u6216\u5df2\u5b8c\u6210\u7f34\u8d39\uff0c\u4e0d\u652f\u6301\u7ec8\u6b62\u64cd\u4f5c\uff01");
        }
        payOrderInfoExt.setPaymentStatus(InquiryPaymentStatus.TERMINATED.getCode());
        try {
            this.inquiryPayOrderMapper.updateState(payOrderInfoExt);
        }
        catch (Exception e) {
            respCode = "6003";
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25");
        }
        FscBaseRspBo rspBO = new FscBaseRspBo();
        if (StringUtils.hasText((String)respCode)) {
            rspBO.setRespCode(respCode);
        }
        return rspBO;
    }
}

