/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.PayQryCheckingByMonthService;
import com.tydic.fsc.settle.busi.api.bo.PayQryCheckingColReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayQryCheckingColRspBO;
import com.tydic.fsc.settle.busi.api.vo.PayCheckingColVO;
import com.tydic.fsc.settle.busi.impl.PayQryCheckingServiceImpl;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.InquiryCheckingMapper;
import com.tydic.fsc.settle.dao.OrgPayConfigMapper;
import com.tydic.fsc.settle.dao.po.CheckingAccRec;
import com.tydic.fsc.settle.dao.po.OrgPayConfigPO;
import com.tydic.fsc.settle.dao.po.PayCheckingRst;
import com.tydic.fsc.settle.dao.vo.PayCheckingRstVO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayQryCheckingByMonthServiceImpl
implements PayQryCheckingByMonthService {
    private static final Logger logger = LoggerFactory.getLogger(PayQryCheckingServiceImpl.class);
    @Autowired
    private InquiryCheckingMapper inquiryCheckingMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private OrgPayConfigMapper orgPayConfigMapper;
    @Autowired
    private EnumsService enumsService;

    public PayQryCheckingColRspBO<PayCheckingColVO> queryCheckingByMonth(PayQryCheckingColReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PayCheckingRstVO record = new PayCheckingRstVO();
        record.setCheckType("Month");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        sdf.setLenient(false);
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate())) {
            Calendar startDate = Calendar.getInstance();
            try {
                startDate.setTime(sdf.parse(reqBO.getStartDate()));
                startDate.set(5, 1);
                record.setStartDate(startDate.getTime());
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new BusinessException("7777", "\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate())) {
            Calendar endDate = Calendar.getInstance();
            try {
                endDate.setTime(sdf.parse(reqBO.getEndDate()));
                endDate.add(2, 1);
                endDate.add(5, -1);
                record.setEndDate(endDate.getTime());
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u7ed3\u675f\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new BusinessException("7777", "\u5165\u53c2\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate()) && null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate()) && record.getStartDate().after(record.getEndDate())) {
            throw new BusinessException("7777", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f!");
        }
        record.setOperUnitNo(reqBO.getCompanyId());
        PayQryCheckingColRspBO payQryCheckingColRspBO = new PayQryCheckingColRspBO();
        LinkedList<PayCheckingColVO> rspBOs = new LinkedList<PayCheckingColVO>();
        List<PayCheckingRst> payCheckingRsts = null;
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        payCheckingRsts = this.inquiryCheckingMapper.queryListPage(record, (Page<Map<String, Object>>)page);
        if (null != payCheckingRsts && !payCheckingRsts.isEmpty()) {
            for (PayCheckingRst po : payCheckingRsts) {
                Date settleDate;
                PayCheckingColVO vo = new PayCheckingColVO();
                BeanUtils.copyProperties((Object)po, (Object)vo);
                try {
                    settleDate = sdf.parse(sdf.format(vo.getSettleDate()));
                }
                catch (ParseException e) {
                    logger.error("[payDate]\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "[payDate]\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!");
                }
                vo.setSettleDate(settleDate);
                if (vo.getOrderCount().compareTo(vo.getPayCount()) == 0 && vo.getPayCount().compareTo(vo.getOrderPaySameCount()) == 0) {
                    vo.setOrderPayCountRst('Y');
                } else {
                    vo.setOrderPayCountRst('N');
                }
                if (null != vo.getOrderTotalAmt() && null != vo.getPayTotalAmt() && null != vo.getOrderPaySameAmt() && vo.getOrderTotalAmt().compareTo(vo.getPayTotalAmt()) == 0 && vo.getPayTotalAmt().compareTo(vo.getOrderPaySameAmt()) == 0) {
                    vo.setOrderPayTotalAmtRst('Y');
                } else {
                    vo.setOrderPayTotalAmtRst('N');
                }
                CheckingAccRec accRec = this.queryBankRec(reqBO.getCompanyId(), reqBO.getCompanyName(), po.getSettleDate());
                if (null != accRec && null != accRec.getTotalAmt()) {
                    vo.setBankRecAmt(accRec.getTotalAmt());
                    if (null != vo.getBankRecAmt() && null != vo.getPayTotalAmt() && vo.getBankRecAmt().compareTo(vo.getPayTotalAmt()) == 0) {
                        vo.setPayBankAmtResult('Y');
                    } else {
                        vo.setPayBankAmtResult('N');
                    }
                } else {
                    vo.setPayBankAmtResult('N');
                }
                rspBOs.add(vo);
            }
        }
        payQryCheckingColRspBO.setRows(rspBOs);
        payQryCheckingColRspBO.setRecordsTotal(page.getTotalCount());
        payQryCheckingColRspBO.setTotal(page.getTotalPages());
        payQryCheckingColRspBO.setPageNo(page.getPageNo());
        return payQryCheckingColRspBO;
    }

    public CheckingAccRec queryBankRec(Long companyId, String companyName, Date settleDate) {
        Date endDa;
        OrgPayConfigPO orgPayConfigPO = this.orgPayConfigMapper.queryConByOrgId(companyId);
        if (orgPayConfigPO == null || orgPayConfigPO.getSubAcctNo() == null) {
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u672a\u914d\u7f6e" + companyName + "\u5bf9\u5e94\u7b2c\u4e09\u65b9\u94f6\u884c\u6536\u6b3e\u8d26\u6237\u4fe1\u606f");
        }
        String recSubAcct = orgPayConfigPO.getSubAcctNo();
        CheckingAccRec checkingAccRec = new CheckingAccRec();
        Calendar startD = Calendar.getInstance();
        startD.setTime(settleDate);
        startD.set(5, 2);
        checkingAccRec.setStartDate(startD.getTime());
        Calendar endD = Calendar.getInstance();
        endD.setTime(startD.getTime());
        endD.add(2, 1);
        endD.add(5, -1);
        try {
            endDa = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(new SimpleDateFormat("yyyy-MM-dd").format(endD.getTime()) + " 23:59:59");
        }
        catch (ParseException e) {
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u94f6\u884c\u6536\u6b3e\u7ed3\u675f\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
        }
        checkingAccRec.setEndDate(endDa);
        checkingAccRec.setRecSubAcct(recSubAcct);
        checkingAccRec.setTransferAcctName(this.enumsService.queryLikeSupplierPayTransferAcctName());
        CheckingAccRec accRec = this.advanceReceiveMapper.select4Checking(checkingAccRec);
        return accRec;
    }
}

