/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.comb.impl;

import com.tydic.fsc.settle.busi.api.FscWfEndWithoutSynchFinanceBusiService;
import com.tydic.fsc.settle.busi.api.bo.FscWfEndWithoutSynchFinanceBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscWfEndWithoutSynchFinanceBusiRspBO;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowDataInfoBO;
import com.tydic.fsc.settle.comb.api.FscWfEndWithoutSynchFinanceCombService;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithoutSynchFinanceCombReqBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithoutSynchFinanceCombRspBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.WorkFlowDataInfoVO;
import com.tydic.fsc.settle.enums.WFBillType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscWfEndWithoutSynchFinanceCombService")
public class FscWfEndWithoutSynchFinanceCombServiceImpl
implements FscWfEndWithoutSynchFinanceCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfEndWithoutSynchFinanceCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private WorkFlowDataMapper workFlowDataMapper;
    private FscWfEndWithoutSynchFinanceBusiService fscWfEndWithoutSynchFinanceBusiService;

    @Autowired
    private FscWfEndWithoutSynchFinanceCombServiceImpl(WorkFlowDataMapper workFlowDataMapper, FscWfEndWithoutSynchFinanceBusiService fscWfEndWithoutSynchFinanceBusiService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.fscWfEndWithoutSynchFinanceBusiService = fscWfEndWithoutSynchFinanceBusiService;
    }

    public FscWfEndWithoutSynchFinanceCombRspBO dealWfEndWithoutSynchFinance(FscWfEndWithoutSynchFinanceCombReqBO reqBO) {
        FscWfEndWithoutSynchFinanceCombRspBO rspBO = new FscWfEndWithoutSynchFinanceCombRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        WorkFlowDataInfoVO vo = new WorkFlowDataInfoVO();
        ArrayList<String> billTypeIn = new ArrayList<String>();
        billTypeIn.add(WFBillType.HANDMADE_COLLECTION.getCode());
        vo.setBillTypeIn(billTypeIn);
        vo.setProcInstId(reqBO.getProcInstId());
        vo.setStatus("02");
        vo.setFinancialStatus("'01','22'");
        List<WorkFlowDataInfo> workFlowDataInfoList = this.workFlowDataMapper.selectListByVO(vo);
        if (CollectionUtils.isEmpty(workFlowDataInfoList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65e0\u4efb\u52a1\u9700\u8981\u5904\u7406");
            return rspBO;
        }
        for (WorkFlowDataInfo wfDataInfo : workFlowDataInfoList) {
            String service = wfDataInfo.getFinishEvtService();
            if (!StringUtils.hasLength((String)service)) continue;
            FscWfEndWithoutSynchFinanceBusiReqBO withoutSynchFinanceBusiReqBO = new FscWfEndWithoutSynchFinanceBusiReqBO();
            WorkFlowDataInfoBO workFlowDataInfoBO = new WorkFlowDataInfoBO();
            BeanUtils.copyProperties((Object)wfDataInfo, (Object)workFlowDataInfoBO);
            withoutSynchFinanceBusiReqBO.setWorkFlowDataInfo(workFlowDataInfoBO);
            FscWfEndWithoutSynchFinanceBusiRspBO withoutSynchFinanceBusiRspBO = this.fscWfEndWithoutSynchFinanceBusiService.dealWfEndWithoutSynchFinance(withoutSynchFinanceBusiReqBO);
            if ("0000".equals(withoutSynchFinanceBusiRspBO.getRespCode()) || !IS_DEBUG_ENABLED) continue;
            LOGGER.debug("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u4e0d\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u5931\u8d25" + withoutSynchFinanceBusiRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u4e0d\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscWfEndWithoutSynchFinanceCombReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getProcInstId()) {
            return "\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

