/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.supplier.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.supplier.BusiInvoiceWayDataService;
import com.tydic.fsc.settle.supplier.bo.BusiInvoiceWayDataReqBO;
import com.tydic.fsc.settle.supplier.bo.BusiInvoiceWayDataRspBO;
import com.tydic.fsc.settle.supplier.utils.ESBParamUtil;
import com.tydic.fsc.settle.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.settle.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.settle.supplier.utils.http.HttpRetBean;
import com.tydic.fsc.settle.supplier.vo.BusiInvoiceWayDataVO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiInvoiceWayDataServiceImpl
implements BusiInvoiceWayDataService {
    private static final Log log = LogFactory.getLog(BusiInvoiceWayDataServiceImpl.class);
    @Autowired
    @Qualifier(value="propertyConfigurer")
    private Properties prop;

    public BusiInvoiceWayDataRspBO getInvoiceWayData(BusiInvoiceWayDataReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u8c03\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString()));
        }
        if (reqBO.getQueryData() == null || reqBO.getQueryData().isEmpty()) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiInvoiceWayDataRspBO rspBO = new BusiInvoiceWayDataRspBO();
        ArrayList dataVOList = new ArrayList();
        rspBO.setMailStatusList(dataVOList);
        Map dataMap = reqBO.getQueryData();
        for (Map.Entry entry : dataMap.entrySet()) {
            HttpRetBean httpRetBean;
            String markId = (String)entry.getKey();
            String suppliedId = (String)entry.getValue();
            String reqStr = this.initReqStr(markId);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + suppliedId);
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            log.info((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3--->\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u62a5\u6587:" + reqEsbStr));
            try {
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_SEND_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            }
            catch (Exception e) {
                log.error((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a" + markId + "\u4f9b\u5e94\u5546Id\u4e3a\uff1a" + suppliedId + " err:" + e.getMessage()), (Throwable)e);
                throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
            }
            if (httpRetBean.getStatus() != 200) {
                log.error((Object)("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]"));
                throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
            }
            log.info((Object)("\u8c03\u7528\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.info((Object)"\u8c03\u7528\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new RuntimeException("\u8c03\u7528\u53d1\u7968\u90ae\u5bc4\u72b6\u6001\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiInvoiceWayDataVO dataVO = new BusiInvoiceWayDataVO();
            dataVO.setNotificationNo(markId);
            this.resolveRsp(returnString, rspBO, dataVO);
        }
        return rspBO;
    }

    private String initReqStr(String markId) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"markId\":").append("\"" + markId + "\"").append("}");
        return sb.toString();
    }

    private void resolveRsp(String returnString, BusiInvoiceWayDataRspBO rspBO, BusiInvoiceWayDataVO dataVO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519," + returnString), (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u53d1\u7968\u90ae\u5bc4\u72b6\u6001--\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        if (resultCode.equals("3305")) {
            dataVO.setResultCode(resultCode);
            dataVO.setResultMsg(rspJsonObject.getString("resultMessage"));
            rspBO.getMailStatusList().add(dataVO);
        } else {
            JSONArray resultArray = null;
            try {
                resultArray = JSONObject.parseArray((String)rspJsonObject.getString("result"));
                for (int i = 0; i < resultArray.size(); ++i) {
                    JSONObject jsonObject = resultArray.getJSONObject(i);
                    dataVO.setPostId(jsonObject.getString("postId"));
                    dataVO.setDeliveryId(jsonObject.getString("deliveryId"));
                    dataVO.setPostCompany(jsonObject.getString("postCompany"));
                    dataVO.setPostTime(jsonObject.getString("postTime"));
                    dataVO.setState(jsonObject.getString("state"));
                    dataVO.setResultCode(resultCode);
                    dataVO.setResultMsg(jsonObject.getString("resultMessage"));
                    rspBO.getMailStatusList().add(dataVO);
                }
            }
            catch (Exception e) {
                log.error((Object)"\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
        }
    }
}

