/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.supplier.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.supplier.BusiTransferEntryTotalService;
import com.tydic.fsc.settle.supplier.bo.BusiTransferEntryTotalReqBO;
import com.tydic.fsc.settle.supplier.bo.BusiTransferEntryTotalRspBO;
import com.tydic.fsc.settle.supplier.utils.JsonUtils;
import com.tydic.fsc.settle.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.settle.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.settle.supplier.utils.http.HttpRetBean;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiTransferEntryTotalServiceImpl
implements BusiTransferEntryTotalService {
    private static final Log log = LogFactory.getLog(BusiTransferEntryTotalServiceImpl.class);
    @Autowired
    @Qualifier(value="propertyConfigurer")
    private Properties prop;

    public BusiTransferEntryTotalRspBO transferEntryTotal(BusiTransferEntryTotalReqBO reqBO) {
        HttpRetBean httpRetBean;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7269\u8d28\u6c47\u603b\u5355\u8fde\u63a5\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf \u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString()));
        }
        if (null == reqBO.getSeqid() || !StringUtils.hasText((String)reqBO.getSeqid())) {
            log.error((Object)("\u552f\u4e00\u6807\u5fd7\uff08\u7269\u8d28\u6c47\u603b\u7f16\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u552f\u4e00\u6807\u5fd7\uff08\u7269\u8d28\u6c47\u603b\u7f16\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSsdw() || !StringUtils.hasText((String)reqBO.getSsdw())) {
            log.error((Object)("\u6240\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6240\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getYhdm()) {
            log.error((Object)("\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFlowid()) {
            log.error((Object)("\u6d41\u7a0bId\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6d41\u7a0bId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getItems().isEmpty()) {
            log.error((Object)("\u8bf7\u6c42Item\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bf7\u6c42Item\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        log.info((Object)("\u8bf7\u6c42\u62a5\u6587\u4e3a\uff1a" + reqStr));
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_ENTRYTOTAL_SEND_YUANGUANG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.toString().getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            log.error((Object)("\u7269\u8d28\u6c47\u603b\u5355\u8fde\u63a5\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf \u5931\u8d25,\u6c47\u603b\u5355\u7f16\u53f7\u4e3a:" + reqBO.getSeqid()), (Throwable)e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7269\u8d28\u6c47\u603b\u5355\u8fde\u63a5\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf \u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error((Object)("\u7269\u8d28\u6c47\u603b\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_ENTRYTOTAL_SEND_YUANGUANG_URL") + "]"));
            throw new RuntimeException("\u7269\u8d28\u6c47\u603b\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        log.info((Object)("\u7269\u8d28\u6c47\u603b\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u6210\u529f\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info((Object)"\u7269\u8d28\u6c47\u603b\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u7269\u8d28\u6c47\u603b\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        BusiTransferEntryTotalRspBO rspBO = new BusiTransferEntryTotalRspBO();
        this.resolveRsp(returnString, rspBO);
        return rspBO;
    }

    private void resolveRsp(String returnString, BusiTransferEntryTotalRspBO rspBO) {
        JSONObject rspJsonObject;
        log.debug((Object)("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString));
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error((Object)("\u7269\u8d28\u6c47\u603b\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519, json:" + returnString), (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        rspBO.setSeqId(rspJsonObject.getString("seqid"));
        rspBO.setFinanceNo(rspJsonObject.getString("cwdjid"));
        rspBO.setResponeCode(rspJsonObject.getString("rspcode"));
        rspBO.setRspMsg(rspJsonObject.getString("rspmsg"));
    }
}

