/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatesUtils {
    private static final Log logger = LogFactory.getLog(DatesUtils.class);

    public static Date dateBefore(int dayCntBefore) {
        return DatesUtils.dateBefore(new Date(), dayCntBefore);
    }

    public static Date dateBefore(Date date, int dayCntBefore) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, dayCntBefore);
        return cal.getTime();
    }

    public static Date dateAddSeconds(Date date, int seconds) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static Date dateAddHours(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date dateAddMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, months);
        return cal.getTime();
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String formatDate(Date date, String fmt) {
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        return sdf.format(date);
    }

    public static Date parseDate(String dateYYYYMMdd) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dt = null;
        try {
            dt = sdf.parse(dateYYYYMMdd);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dt;
    }

    public static Date obtainEndOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int dayOfYear = calendar.get(6);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, dayOfYear);
        calendar.add(6, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static int obtainDaysBetween(Date dateStart, Date dateEnd) {
        int daysBetween = 0;
        if (dateStart == null || dateEnd == null) {
            return daysBetween;
        }
        dateStart = DatesUtils.obtainEndOfDay(dateStart);
        dateEnd = DatesUtils.obtainEndOfDay(dateEnd);
        try {
            daysBetween = Double.valueOf((double)(dateEnd.getTime() - dateStart.getTime()) / 8.64E7).intValue();
        }
        catch (Exception e) {
            logger.error((Object)"\u8ba1\u7b97\u51fa\u9519", (Throwable)e);
        }
        return daysBetween;
    }
}

