/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.utils.holytax;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.settle.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.settle.supplier.utils.http.HttpRetBean;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import com.tydic.fsc.settle.utils.holytax.HolytaxBase64Util;
import com.tydic.fsc.settle.utils.holytax.SignUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static MultiThreadedHttpConnectionManager httpConnectionManager = null;
    private static HttpClient httpClient = null;
    private static final Object obj = new Object();
    private static String url;
    private static String appid;
    private static String appsecret;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execute(String xml, String url) throws HttpException, IOException {
        PostMethod post = null;
        try {
            String result;
            post = new PostMethod(url);
            post.getParams().setCookiePolicy("ignoreCookies");
            StringRequestEntity entity = new StringRequestEntity(xml, "text/xml", "gbk");
            post.setRequestEntity((RequestEntity)entity);
            int rs = httpClient.executeMethod((HttpMethod)post);
            if (rs != 200) {
                throw new HttpException("http\u8bf7\u6c42\u72b6\u6001\u5f02\u5e38\uff0c\u5f02\u5e38\u4ee3\u7801\uff1a" + rs);
            }
            String string = result = IOUtils.toString((InputStream)post.getResponseBodyAsStream(), (String)"gbk");
            return string;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public static Map<String, String> post(String url, Map<String, String> params) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost post = HttpUtil.postForm(url, params);
        Map reponseMap = HttpUtil.invoke(httpclient, (HttpUriRequest)post);
        httpclient.getConnectionManager().shutdown();
        return reponseMap;
    }

    private static HttpPost postForm(String url, Map<String, String> params) {
        HttpPost httpost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key)));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return httpost;
    }

    private static Map invoke(DefaultHttpClient httpclient, HttpUriRequest httpost) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HttpResponse response = HttpUtil.sendRequest(httpclient, httpost);
        String body = HttpUtil.paseResponse(response);
        returnMap.put("statusCode", response.getStatusLine().getStatusCode());
        returnMap.put("response", body);
        return returnMap;
    }

    private static HttpResponse sendRequest(DefaultHttpClient httpclient, HttpUriRequest httpost) {
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute(httpost);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private static String paseResponse(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        String charset = EntityUtils.getContentCharSet((HttpEntity)entity);
        String body = null;
        try {
            body = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return body;
    }

    public static String obtainUrl() {
        return url;
    }

    public static String obtainAppid() {
        return appid;
    }

    public static String obtainAppsecret() {
        return appsecret;
    }

    private static void initParameter() {
        Properties prop = (Properties)SpringApplicationContext.getBean("propertyConfigurer");
        if (!StringUtils.hasText((String)url) && null != prop) {
            url = prop.getProperty("ESB_HOLYTAX_ELECTRONIC_INVOICE_URL");
        }
        if (!StringUtils.hasText((String)appid) && null != prop) {
            appid = prop.getProperty("ESB_HOLYTAX_ELECTRONIC_INVOICE_APP_ID");
        }
        if (!StringUtils.hasText((String)appsecret) && null != prop) {
            appsecret = prop.getProperty("ESB_HOLYTAX_ELECTRONIC_INVOICE_APP_SECRET");
        }
    }

    public static String toApplyInvoice(String content) {
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("content", HolytaxBase64Util.encode(content));
        querys.put("appid", HttpUtil.obtainAppid());
        querys.put("timestamp", HttpUtil.getTimeStamp());
        querys.put("serviceid", "S0001");
        querys.put("source", "1");
        querys.put("signkey", "appid,signkey,timestamp,content,serviceid,source");
        String signature = SignUtil.sign(HttpUtil.obtainAppsecret(), querys);
        querys.put("signature", signature);
        JSONObject reqStrObject = (JSONObject)JSONObject.toJSON(querys);
        String reqStr = reqStrObject.toJSONString();
        logger.debug("\u5408\u529b\u4e2d\u7a0e\u5c01\u88c5\u540e\u7684json\u6570\u636e=" + reqStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(HttpUtil.obtainUrl()), HSNHttpHeader.getRequestHeaders("json"), reqStr.toString().getBytes("UTF-8"), "UTF-8", false);
            String returnStr = httpRetBean.getStr();
            logger.debug("\u5408\u529b\u4e2d\u7a0e\u8fd4\u56de\u6570\u636e=" + returnStr);
            return returnStr;
        }
        catch (Exception e) {
            throw new BusinessException("1002", e.getMessage(), (Throwable)e);
        }
    }

    private static String getTimeStamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return sdf.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HttpUtil.initParameter();
        if (httpClient == null) {
            Object object = obj;
            synchronized (object) {
                if (httpClient == null) {
                    httpConnectionManager = new MultiThreadedHttpConnectionManager();
                }
                httpClient = new HttpClient((HttpConnectionManager)httpConnectionManager);
                httpClient.getHttpConnectionManager().getParams().setDefaultMaxConnectionsPerHost(30);
                httpClient.getHttpConnectionManager().getParams().setMaxTotalConnections(48);
                httpClient.getHttpConnectionManager().getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
                httpClient.getParams().setCookiePolicy("ignoreCookies");
                httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
                httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
                httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"gbk");
            }
        }
    }
}

