/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.tydic.fsc.settle.dao.JobMasterMapper;
import com.tydic.fsc.settle.dao.po.JobMaster;
import com.tydic.fsc.settle.utils.DatesUtils;
import com.tydic.fsc.settle.utils.Rnd;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jobMasterService")
public class JobMasterService {
    private static final Log logger = LogFactory.getLog(JobMasterService.class);
    @Autowired
    private JobMasterMapper jobMasterMapper;

    public String enRollAsMaster(String jobName, String oldCheckCode, String extData, int holdSeconds) {
        JobMaster job = this.jobMasterMapper.selectByPrimaryKey(jobName);
        String checkCode = JobMasterService.createCheckCode();
        Date now = new Date();
        if (job == null) {
            job = new JobMaster();
            job.setJobName(jobName);
            job.setJobDescr(jobName);
            job.setCheckCode(checkCode);
            job.setLastDate(now);
            if (extData != null) {
                job.setExtData(extData);
            }
            if (holdSeconds > 0) {
                job.setExpiredDate(DatesUtils.dateAddSeconds(now, holdSeconds));
            }
            try {
                this.jobMasterMapper.insert(job);
                return checkCode;
            }
            catch (Exception e) {
                logger.error((Object)("\u65b0\u589e\u4e3bAPP\u767b\u8bb0\u5931\u8d25,jobName=" + jobName));
                return null;
            }
        }
        boolean isExpired = true;
        boolean dataExists = false;
        if (holdSeconds > 0) {
            boolean bl = isExpired = now.compareTo(job.getExpiredDate()) > 0;
        }
        if (extData != null && extData.equals(job.getExtData())) {
            dataExists = true;
        }
        logger.debug((Object)("MASTER APP:isExp=" + isExpired + "," + job.getExpiredDate() + ",mine=" + oldCheckCode + ",now=" + job.getCheckCode()));
        if (!isExpired || dataExists) {
            if (!job.getCheckCode().equals(oldCheckCode)) {
                logger.error((Object)("\u4e3bAPP\u767b\u8bb0\u5931\u8d25,\u5df2\u5b58\u5728\u5176\u5b83\u4e3bAPP\u6d3b\u8dc3:" + job.getCheckCode() + ",mine:" + oldCheckCode));
                return null;
            }
            job = new JobMaster();
            job.setJobName(jobName);
            job.setLastDate(now);
            if (extData != null) {
                job.setExtData(extData);
            }
            if (holdSeconds > 0) {
                job.setExpiredDate(DatesUtils.dateAddSeconds(now, holdSeconds));
            }
            try {
                int cnt = this.jobMasterMapper.updateByPrimaryKeySelective(job);
                logger.debug((Object)("\u4e3bAPP\u7eed\u8ba2,\u6570\u91cf:" + cnt + ",myCode:" + oldCheckCode));
                return oldCheckCode;
            }
            catch (Exception e) {
                logger.error((Object)("\u4e3bAPP\u767b\u8bb0\u66f4\u65b0\u5931\u8d25,jobName=" + jobName), (Throwable)e);
                return null;
            }
        }
        JobMaster updateJob = new JobMaster();
        updateJob.setJobName(jobName);
        updateJob.setOldCheckCode(job.getCheckCode());
        updateJob.setCheckCode(checkCode);
        updateJob.setLastDate(now);
        if (extData != null) {
            updateJob.setExtData(extData);
        }
        if (holdSeconds > 0) {
            updateJob.setExpiredDate(DatesUtils.dateAddSeconds(now, holdSeconds));
        }
        try {
            int cnt = this.jobMasterMapper.updateCheckCode(updateJob);
            logger.debug((Object)("\u4e3bAPP\u767b\u8bb0,\u6570\u91cf:" + cnt + ",newCode:" + updateJob.getCheckCode() + ",old:" + updateJob.getOldCheckCode()));
            if (cnt == 0) {
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e3bAPP\u767b\u8bb0\u66f4\u65b0\u5931\u8d25,jobName=" + jobName), (Throwable)e);
            return null;
        }
        return checkCode;
    }

    public static String createCheckCode() {
        int v1 = Rnd.rnd(10000000, 99999999);
        int v2 = Rnd.rnd(10000000, 99999999);
        return v1 + "" + v2;
    }
}

