/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.InvokePaycenterService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.po.PayableDetailPO;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.PayablePayType;
import com.tydic.fsc.settle.enums.PayableStatus;
import com.tydic.fsc.settle.utils.DatesUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payPayableService")
public class PayableService {
    private static final Logger logger = LoggerFactory.getLogger(PayableService.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private InvokePaycenterService invokePaycenterService;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public void applyForNew(String payableNo, BigDecimal amount) {
        this.doAction(payableNo, amount, 1);
    }

    public void cancelPay(String payableNo, BigDecimal amount) {
        this.doAction(payableNo, amount, 2);
    }

    public void completePay(String payableNo, BigDecimal amount) {
        this.doAction(payableNo, amount, 3);
    }

    private PayableDetailPO checkParamter(String payableNo, BigDecimal amount) {
        if (!StringUtils.hasText((String)payableNo)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5e94\u4ed8\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d89\u53ca\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        PayableDetailPO payable = null;
        try {
            payable = this.payableDetailMapper.getModelById(payableNo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo, (Throwable)e);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25" + e.getMessage());
        }
        if (payable == null) {
            logger.debug("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728,\u5e94\u4ed8\u5355=" + payableNo);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        return payable;
    }

    private void doAction(String payableNo, BigDecimal amount, int actType) {
        logger.debug("---\u51c6\u5907\u5904\u7406\u5e94\u4ed8\u5355\u7684\u76f8\u5173\u91d1\u989d\u64cd\u4f5c,\u5e94\u4ed8\u5355\u53f7=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",actType=" + actType);
        PayableDetailPO payable = this.checkParamter(payableNo, amount);
        if (payable.getPendingAmt() == null) {
            logger.debug("\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u4e2d\u91d1\u989d(pendingAmt)\u4e3anull,\u5e94\u4ed8\u5355\u53f7=" + payableNo);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6b64\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u4e2d\u91d1\u989d\u6570\u636e\u5f02\u5e38");
        }
        if (payable.getPayableAmt() == null) {
            logger.debug("\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u91d1\u989d(payableAmt)\u4e3anull,\u5e94\u4ed8\u5355\u53f7=" + payableNo);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6b64\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
        }
        PayableDetailPO forUpdate = new PayableDetailPO();
        forUpdate.setPayableAmt(payable.getPendingAmt());
        if (actType == 1) {
            if (payable.getPayableAmt().compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u603b\u91d1\u989d=" + payable.getPayableAmt());
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u5e94\u4ed8\u5355\u53f7\u7684\u603b\u91d1\u989d" + payable.getPayableAmt());
            }
            BigDecimal remainAmt = payable.getPayableAmt().subtract(payable.getPaidAmt()).subtract(payable.getPendingAmt());
            if (remainAmt.compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u8d85\u51fa\u5269\u4f59\u91d1\u989d,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u5269\u4f59\u91d1\u989d=" + remainAmt);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u9700\u652f\u4ed8\u7684\u91d1\u989d" + remainAmt);
            }
            forUpdate.setPendingAmt(amount);
            forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
        } else {
            BigDecimal pendingAmt = payable.getPendingAmt();
            BigDecimal paidAmt = payable.getPaidAmt();
            if (pendingAmt.compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u8d85\u51fa\u4ed8\u6b3e\u4e2d\u91d1\u989d,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u4ed8\u6b3e\u4e2d\u91d1\u989d=" + payable.getPendingAmt());
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d" + payable.getPendingAmt());
            }
            if (actType == 3) {
                if ((paidAmt = paidAmt.add(amount)).compareTo(payable.getPayableAmt()) == 0) {
                    forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
                }
                forUpdate.setPaidAmt(amount);
            }
            forUpdate.setPendingAmt(amount.negate());
            pendingAmt = pendingAmt.subtract(amount);
            if (pendingAmt.compareTo(BigDecimal.ZERO) == 0 && paidAmt.compareTo(BigDecimal.ZERO) == 0) {
                forUpdate.setPayableStatus(PayableStatus.PENDING.getCode());
            }
        }
        forUpdate.setPayableNo(payableNo);
        logger.debug("\u51c6\u5907\u4fee\u6539\u5e94\u4ed8\u5355\u7684\u76f8\u5173\u91d1\u989d,act=" + actType + ",\u53c2\u6570=" + forUpdate);
        int cnt = this.payableDetailMapper.updateAmount(forUpdate);
        if (cnt != 1) {
            logger.error("\u5e94\u4ed8\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u91d1\u989d\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo + ",\u91d1\u989d=" + amount + ",\u66f4\u65b0\u6570=" + cnt);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25,\u6b64\u9884\u4ed8\u5355\u53d1\u751f\u4e86\u53d8\u5316,\u8bf7\u91cd\u65b0\u64cd\u4f5c.");
        }
    }

    public List<PayableDetailPO> createPayableBill(String notificationNo) {
        BillNotificationInfo singleNotiInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (singleNotiInfo == null) {
            throw new BusinessException("1002", "\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355");
        }
        String source = singleNotiInfo.getSource();
        OrderSource src = OrderSource.getInstance((String)source);
        ArrayList<PayableDetailPO> result = new ArrayList<PayableDetailPO>();
        if (OrderSource.ELECTRIC_AREA == src || OrderSource.CONSULT_PRICE == src || OrderSource.COAL_AREA == src) {
            List<PayItemInfo> orders = this.payItemInfoMapper.selectGroupByOrder(notificationNo);
            BigDecimal totalAgainstAmt = BigDecimal.ZERO;
            for (PayItemInfo ord : orders) {
                BigDecimal warrantyAmount;
                Long inspectionId = ord.getInspectionId();
                BigDecimal amount = ord.getAmount();
                if ((OrderSource.ELECTRIC_AREA == src || OrderSource.COAL_AREA == src) && (warrantyAmount = this.invokePaycenterService.obtainWarrantyAmt4PurchaseInspection(inspectionId)).compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal amt = warrantyAmount.compareTo(amount) <= 0 ? warrantyAmount : amount;
                    totalAgainstAmt = totalAgainstAmt.add(amt);
                    amount = amount.subtract(amt);
                }
                PayableDetailPO param = new PayableDetailPO();
                param.setOperatorId(singleNotiInfo.getOperNo());
                param.setNeedAgainstAmt(BigDecimal.ZERO);
                param.setPayType(PayablePayType.PREPAY.getCode());
                param.setOrderId(ord.getOrderId());
                param.setOrderBy("NEED_AGAINST_AMT asc");
                List<PayableDetailPO> list = this.payableDetailMapper.getList(param);
                ArrayList<PayableDetailPO> againstList = new ArrayList<PayableDetailPO>();
                for (PayableDetailPO po : list) {
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) break;
                    BigDecimal amt = po.getNeedAgainstAmt();
                    if (amt.compareTo(amount) <= 0) {
                        po.setNeedAgainstAmt(BigDecimal.ZERO);
                        totalAgainstAmt = totalAgainstAmt.add(amt);
                    } else {
                        po.setNeedAgainstAmt(amt.subtract(amount));
                        totalAgainstAmt = totalAgainstAmt.add(amount);
                    }
                    amount = amount.subtract(amt);
                    againstList.add(po);
                }
                for (PayableDetailPO po : againstList) {
                    PayableDetailPO forUpdate = new PayableDetailPO();
                    forUpdate.setPayableNo(po.getPayableNo());
                    forUpdate.setNeedAgainstAmt(po.getNeedAgainstAmt());
                    this.payableDetailMapper.updateAmount(forUpdate);
                }
                if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                param = this.createPayable(singleNotiInfo, source, PayablePayType.PAY, ord, singleNotiInfo.getOperNo(), singleNotiInfo.getSupplierNo(), amount, PayableStatus.PENDING, null);
                result.add(param);
            }
            if (result.size() > 0) {
                ((PayableDetailPO)result.get(0)).setNeedAgainstAmt(totalAgainstAmt);
            }
            return result;
        }
        SupplierInfo supInfo = this.supplierInfoMapper.selectByPrimaryKey(singleNotiInfo.getSupplierNo());
        if (supInfo == null) {
            logger.error("\u4ea7\u751f\u5e94\u6536\u5931\u8d25(\u7535\u5b50\u8d85\u5e02),\u627e\u4e0d\u5230\u4f9b\u5e94\u5546\u7684\u5408\u540c\u53f7,\u4f9b\u5e94\u5546=" + singleNotiInfo.getSupplierNo());
            throw new BusinessException("1002", "\u83b7\u53d6\u4f9b\u5e94\u5546\u7684\u91c7\u8d2d\u5408\u540c\u53f7\u5931\u8d25");
        }
        Integer month = supInfo.getAcRateMonth();
        Date payDate = DatesUtils.dateAddMonths(new Date(), month);
        PayItemInfo ord = new PayItemInfo();
        ord.setUnitName(supInfo.getEffectContactNo());
        result.add(this.createPayable(singleNotiInfo, source, PayablePayType.PAY, ord, singleNotiInfo.getOperNo(), singleNotiInfo.getSupplierNo(), singleNotiInfo.getAmt(), PayableStatus.PENDING, payDate));
        ((PayableDetailPO)result.get(0)).setNeedAgainstAmt(BigDecimal.ZERO);
        return result;
    }

    public PayableDetailPO createPrepayBill(PayItemInfo ord, Long operUnitNo, Long supNo, BigDecimal payableAmt, String source) {
        if (ord == null || ord.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (supNo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u5546\u5fc5\u987b\u8f93\u5165");
        }
        if (operUnitNo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e13\u4e1a\u516c\u53f8ID\u5fc5\u987b\u8f93\u5165");
        }
        if (source == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6240\u5c5e\u6765\u6e90\u5fc5\u987b\u8f93\u5165");
        }
        if (payableAmt == null || payableAmt.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.createPayable(null, source, PayablePayType.PREPAY, ord, operUnitNo, supNo, payableAmt, PayableStatus.PENDING, null);
    }

    private PayableDetailPO createPayable(BillNotificationInfo notification, String source, PayablePayType payType, PayItemInfo item, Long operUnitNo, Long supNo, BigDecimal payableAmt, PayableStatus status, Date payDate) {
        PayableDetailPO po = new PayableDetailPO();
        Long snNo = this.billSNService.getSn(BillType.PAYABLE_ACCOUNT);
        po.setPayableNo(String.valueOf(snNo));
        if (notification != null) {
            po.setNotificationNo(notification.getNotificationNo());
            po.setProfessionalDepartId(notification.getProfessionalDepartId());
            po.setServiceDepartId(notification.getServiceDepartId());
        }
        po.setOperatorId(operUnitNo);
        if (item != null) {
            po.setOrderId(item.getOrderId());
            po.setInspectionId(item.getInspectionId());
            po.setPurchaseOrderCode(item.getPurchaseOrderCode());
            po.setPurchaseOrderName(item.getItemName());
            po.setPlaAgreementCode(item.getUnitName());
            PayPurchaseOrderInfo order = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(item.getOrderId(), item.getInspectionId());
            if (order != null) {
                po.setBranchCompany(order.getBranchCompany());
            }
        }
        po.setSupplierId(supNo);
        po.setPayableAmt(payableAmt);
        po.setPaidAmt(BigDecimal.ZERO);
        po.setPendingAmt(BigDecimal.ZERO);
        po.setPayType(payType.getCode());
        po.setNeedAgainstAmt(payableAmt);
        po.setSource(source);
        po.setPayableStatus(status.getCode());
        po.setPaidDate(payDate);
        this.payableDetailMapper.insert(po);
        return po;
    }
}

