/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.tydic.fsc.settle.atom.PingAnCustIDService;
import com.tydic.fsc.settle.atom.bo.PingAnResult;
import com.tydic.fsc.supplier.BusiSubAcctManageService;
import com.tydic.fsc.supplier.BusiSubAcctTransService;
import com.tydic.fsc.supplier.bo.BusiSubAcctManageReqBO;
import com.tydic.fsc.supplier.bo.BusiSubAcctManageRspBO;
import com.tydic.fsc.supplier.bo.BusiSubAcctTransReqBO;
import com.tydic.fsc.supplier.bo.BusiSubAcctTransRspBO;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pingAnBankService")
public class PingAnBankService {
    private static final Log logger = LogFactory.getLog(PingAnBankService.class);
    public static String TRANS_TYPE_SUB_TO_SUB = "0";
    public static String TRANS_TYPE_SUB_TO_MAIN = "1";
    public static String TRANS_TYPE_MAIN_TO_SUB = "2";
    @Autowired
    private BusiSubAcctTransService busiSubAcctTransService;
    @Autowired
    private BusiSubAcctManageService busiSubAcctManageService;
    @Autowired
    private PingAnCustIDService pingAnCustIDService;

    public PingAnResult accountTransfer(String mainAcctNo, String mainAcctName, String transType, String fromAcctNo, String fromAcctName, String toAcctNo, String toAcctName, BigDecimal amount, String remark) {
        if (transType == null || transType.length() == 0) {
            transType = TRANS_TYPE_SUB_TO_SUB;
        }
        String reqSn = this.pingAnCustIDService.genReqSn();
        BusiSubAcctTransReqBO reqBO = new BusiSubAcctTransReqBO();
        reqBO.setConsumerSeqNo(reqSn);
        reqBO.setJiaoyije(amount);
        reqBO.setTiaozlb(transType);
        reqBO.setZhaiyao(remark);
        reqBO.setZhuanczh(fromAcctNo);
        reqBO.setZhuanczhmc(fromAcctName);
        reqBO.setZhuanrzh(toAcctNo);
        reqBO.setZhuanrzhmc(toAcctName);
        reqBO.setZhuzhanghao(mainAcctNo);
        reqBO.setZhuzhmc(mainAcctName);
        BusiSubAcctTransRspBO bo = null;
        PingAnResult result = new PingAnResult();
        result.setSuccess(false);
        long tick = System.currentTimeMillis();
        try {
            bo = this.busiSubAcctTransService.subAcctTransfer(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("\u8c03\u5e73\u5b89\u94f6\u884c\u5b50\u8d26\u6237\u8d44\u91d1\u5212\u8f6c\u63a5\u53e3Sub account transer error" + e.getMessage()), (Throwable)e);
            result.setReturnCode("000001");
            result.setReturnMsg("Exception " + e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ReturnBO:" + bo));
        }
        if (bo != null) {
            result.setResSn(bo.getRspSeqNo());
            result.setReturnCode(bo.getRespCode());
            result.setReturnMsg(bo.getRespDesc());
        }
        logger.info((Object)("--\u8c03\u5e73\u5b89\u94f6\u884c\u5b50\u8d26\u53f7\u8f6c\u8d26Sub account transfer,su:" + result.isSuccess() + " reqSn:" + reqSn + " rspSn:" + result.getResSn() + " mainAcctNo:" + mainAcctNo + " fromAcctNo:" + fromAcctNo + " toAcctNo:" + toAcctNo + " returnCode:" + result.getReturnCode() + " returnMsg:" + result.getReturnMsg() + " timeCost:" + (System.currentTimeMillis() - tick) + "ms"));
        result.setAccountDate(new Date());
        result.setTranDate(new Date());
        return result;
    }

    public PingAnResult createSubAccount(String mainAcctNo, String subAcctName, boolean allowOverdraft) {
        String reqSn = this.pingAnCustIDService.genReqSn();
        String allowOverdraftFlag = "0";
        if (allowOverdraft) {
            allowOverdraftFlag = "1";
        }
        BusiSubAcctManageReqBO reqBO = new BusiSubAcctManageReqBO();
        reqBO.setConsumerSeqNo(reqSn);
        reqBO.setShoukgnm("A");
        reqBO.setTouzhibz(allowOverdraftFlag);
        reqBO.setZhuzhanghao(mainAcctNo);
        reqBO.setZizhmc(subAcctName);
        reqBO.setZizhanghao("");
        reqBO.setZizhsxh("");
        reqBO.setJixibj("0");
        reqBO.setJixilv(new BigDecimal(0));
        reqBO.setJixizq("1QA21E");
        reqBO.setBeizhu1("");
        reqBO.setBeizhu2("");
        reqBO.setBeizhu3("");
        reqBO.setBeizhu4("");
        reqBO.setBeizhu5("");
        reqBO.setBeizhu6("");
        BusiSubAcctManageRspBO bo = null;
        PingAnResult result = new PingAnResult();
        result.setSuccess(false);
        long tick = System.currentTimeMillis();
        try {
            bo = this.busiSubAcctManageService.subAcctManage(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("create sub account error" + e.getMessage()), (Throwable)e);
            result.setReturnCode("000001");
            result.setReturnMsg("Exception " + e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ReturnBO:" + bo));
        }
        if (bo != null) {
            result.setReturnCode(bo.getRespCode());
            result.setReturnMsg(bo.getRespDesc());
            result.setSubAcctNo(bo.getZizhanghao());
        }
        logger.info((Object)("--\u521b\u5efa\u5b50\u8d26\u53f7Create sub account,su:" + result.isSuccess() + " reqSn:" + reqSn + " mainAcctNo:" + mainAcctNo + " subAcctNo:[" + result.getSubAcctNo() + "] returnCode:" + result.getReturnCode() + " returnMsg:" + result.getReturnMsg() + " timeCost:" + (System.currentTimeMillis() - tick) + "ms"));
        result.setAccountDate(new Date());
        result.setTranDate(new Date());
        return result;
    }
}

