/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiAddBillApplyInfoByItemsService;
import com.tydic.fsc.settle.busi.api.BusiAddBillApplyInfoByTaxRateService;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillApplyInfoByItemsDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillApplyInfoByItemsReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillApplyInfoByItemsRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillApplyInfoByTaxRateReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillApplyInfoByTaxRateRspBO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceHeaderVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceMailAddrInfoVO;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAddBillApplyInfoByTaxRateServiceImpl
implements BusiAddBillApplyInfoByTaxRateService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillApplyInfoByTaxRateServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BusiAddBillApplyInfoByItemsService busiAddBillApplyInfoByItemsService;

    public BusiAddBillApplyInfoByTaxRateRspBO add(BusiAddBillApplyInfoByTaxRateReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5408\u5e76\u5f00\u7968\u65b0\u8d60\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        List inspectionIds = reqBO.getInspectionIds();
        if (invoiceInfo == null) {
            throw new BusinessException("1001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new BusinessException("1001", "\u53d1\u7968\u4fe1\u606f\u4e2d\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null || !StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new BusinessException("1001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isEmpty((Collection)inspectionIds)) {
            throw new BusinessException("1001", "\u8bf7\u9009\u62e9\u8ba2\u5355\u6570\u636e");
        }
        LinkedList<BusiAddBillApplyInfoByItemsDetailReqBO> detailInfoList = new LinkedList<BusiAddBillApplyInfoByItemsDetailReqBO>();
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setInspectionIdList(inspectionIds);
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        List<SaleItemInfoVO> saleItemList = this.saleItemInfoMapper.querySaleJoinOrderItemList(saleItemInfoVO);
        if (CollectionUtils.isEmpty(saleItemList)) {
            throw new BusinessException("1001", "\u4e0d\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        for (SaleItemInfoVO saleItemVO : saleItemList) {
            BigDecimal quantityRemain = saleItemVO.getQuantity().subtract(saleItemVO.getQuantityApplied());
            BigDecimal amountRemain = saleItemVO.getAmount().subtract(saleItemVO.getAmountApplied());
            if (quantityRemain.compareTo(BigDecimal.ZERO) <= 0 || amountRemain.compareTo(BigDecimal.ZERO) <= 0) continue;
            BusiAddBillApplyInfoByItemsDetailReqBO detailReqBO = new BusiAddBillApplyInfoByItemsDetailReqBO();
            detailReqBO.setSeq(saleItemVO.getSeq());
            detailReqBO.setQuantityApply(quantityRemain);
            detailInfoList.add(detailReqBO);
        }
        if (CollectionUtils.isEmpty(detailInfoList)) {
            throw new BusinessException("1001", "\u4e0d\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        BusiAddBillApplyInfoByItemsReqBO busiAddBillApplyInfoByItemsReqBO = new BusiAddBillApplyInfoByItemsReqBO();
        busiAddBillApplyInfoByItemsReqBO.setInvoiceInfo(invoiceInfo);
        busiAddBillApplyInfoByItemsReqBO.setMailAddrInfo(mailAddrInfo);
        busiAddBillApplyInfoByItemsReqBO.setDetailInfoList(detailInfoList);
        busiAddBillApplyInfoByItemsReqBO.setUserId(reqBO.getUserId());
        BusiAddBillApplyInfoByItemsRspBO itemRspBO = this.busiAddBillApplyInfoByItemsService.add(busiAddBillApplyInfoByItemsReqBO);
        BusiAddBillApplyInfoByTaxRateRspBO rspBO = new BusiAddBillApplyInfoByTaxRateRspBO();
        rspBO.setMsg(itemRspBO.getMsg());
        return rspBO;
    }
}

