/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.fsc.settle.atom.FscWfStartAtomService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomRspBO;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAdvanceRecManualService;
import com.tydic.fsc.settle.busi.api.bo.BusiAdvanceRecManualReqBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.BillInfoMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.BillInfo;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.AdvanceReceiveTransactionType;
import com.tydic.fsc.settle.enums.DebitCreditFlag;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.WFBillType;
import com.tydic.fsc.supplier.bo.UserDetailInfoBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAdvanceRecManualServiceImpl
implements BusiAdvanceRecManualService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAdvanceRecManualServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private OrderSequence advanceReveiveReq;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private BillInfoMapper billInfoMapper;
    private SubAccountService subAccountService;
    private FscWfStartAtomService fscWfStartAtomService;
    private OrganizationInfoService organizationInfoService;
    private UserInfoService userInfoService;

    @Autowired
    private BusiAdvanceRecManualServiceImpl(@Qualifier(value="advanceReveiveReq") OrderSequence advanceReveiveReq, AdvanceReceiveMapper advanceReceiveMapper, BillInfoMapper billInfoMapper, SubAccountService subAccountService, FscWfStartAtomService fscWfStartAtomService, OrganizationInfoService organizationInfoService, UserInfoService userInfoService) {
        this.advanceReveiveReq = advanceReveiveReq;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.billInfoMapper = billInfoMapper;
        this.subAccountService = subAccountService;
        this.fscWfStartAtomService = fscWfStartAtomService;
        this.organizationInfoService = organizationInfoService;
        this.userInfoService = userInfoService;
    }

    public FscBaseRspBo addBusiAdvanceRecManual(BusiAdvanceRecManualReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u624b\u5de5\u5f55\u5165\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource()) && ReceiveType.BILL_RECEIVE.getCode().equals(reqBO.getRecType())) {
            throw new BusinessException("1002", "\u82e5\u6765\u6e90\u662f" + OrderSource.ELECTRIC_MARKET.getDescr() + "\uff0c\u6536\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u662f" + ReceiveType.BILL_RECEIVE.getDescr());
        }
        UserDetailInfoBO userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId());
        if (null != userDetailInfoBO) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new BusinessException("1001", "\u516c\u53f8ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getRecType())) {
            throw new BusinessException("1001", "\u6536\u6b3e\u65b9\u5f0f[recType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getRecSubAcct())) {
            throw new BusinessException("1001", "\u8f6c\u5165\u8d26\u6237[recSubAcct]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTranAmt()) {
            throw new BusinessException("1001", "\u4ea4\u6613\u91d1\u989d[tranAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTranAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("1001", "\u4ea4\u6613\u91d1\u989d[tranAmt]\u5e94\u5927\u4e8e0");
        }
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new BusinessException("1001", "\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayOrgId() == null) {
            throw new BusinessException("1001", "\u4ed8\u6b3e\u5355\u4f4d[payOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(reqBO.getRecSubAcct());
        if (null == subAcctInfoExt) {
            throw new BusinessException("1002", "\u6839\u636e\u5165\u53c2\u8f6c\u5165\u65b9\u5b50\u8d26\u6237\u672a\u67e5\u8be2\u5230\u8be5\u5b50\u8d26\u6237\u53ca\u5176\u4e3b\u8d26\u6237\u4fe1\u606f");
        }
        if (!reqBO.getCompanyId().equals(subAcctInfoExt.getSuperiorOrgId())) {
            throw new BusinessException("1002", "\u7528\u6237\u6743\u9650\u4e0d\u8db3\uff0c\u8f6c\u5165\u8d26\u6237\u6240\u5c5e\u4e3b\u8d26\u53f7\u7684\u673a\u6784ID\u5fc5\u987b\u7b49\u4e8e\u7528\u6237\u7684\u516c\u53f8ID");
        }
        if (!SubAccountServiceType.DEFAULT.getCode().equals(subAcctInfoExt.getServiceType()) && !SubAccountServiceType.DISTRIBUTE_BUSINESS.getCode().equals(subAcctInfoExt.getServiceType())) {
            throw new BusinessException("1002", "\u624b\u5de5\u6536\u6b3e\u53ea\u652f\u6301" + SubAccountServiceType.DEFAULT.getDescr() + "," + SubAccountServiceType.DISTRIBUTE_BUSINESS.getDescr());
        }
        AdvanceReceive advanceReceive = new AdvanceReceive();
        try {
            BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceive);
        }
        catch (Exception e) {
            throw new BusinessException("1002", "\u7cfb\u7edf\u5f02\u5e38");
        }
        long advanceReceiveSeq = 0L;
        try {
            advanceReceiveSeq = this.advanceReveiveReq.nextId();
        }
        catch (SQLException e) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u83b7\u53d6D_ADVANCE_RECEIVE_SEQ\u5e8f\u5217\u5931\u8d25");
        }
        advanceReceive.setSeq(advanceReceiveSeq);
        advanceReceive.setTranType(AdvanceReceiveTransactionType.MANUAL_RECEIVE.getCode());
        advanceReceive.setSource(subAcctInfoExt.getSource());
        advanceReceive.setRecAcct(subAcctInfoExt.getMainAcctNo());
        advanceReceive.setPayOrgId(subAcctInfoExt.getOrgId());
        advanceReceive.setRecOrgId(subAcctInfoExt.getSuperiorOrgId());
        advanceReceive.setPostDate(new Date());
        advanceReceive.setCreateDate(new Date());
        advanceReceive.setDebitCreditFlag(DebitCreditFlag.CREDIT.getCode());
        advanceReceive.setStatus(AdvanceReceiveStatus.PENDING_APPROVA.getCode());
        advanceReceive.setTransferAcctName(this.organizationInfoService.queryProjectName(reqBO.getPayOrgId()).getAccountName());
        advanceReceive.setCreateUser(reqBO.getUserId());
        if (ReceiveType.BANK_RECEIVE.getCode().equals(reqBO.getRecType())) {
            this.advanceReceiveMapper.insert(advanceReceive);
        } else {
            if (null == reqBO.getBillDate()) {
                throw new BusinessException("1001", "\u51fa\u7968\u65e5\u671f[billDate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getBillerAcct())) {
                throw new BusinessException("1001", "\u51fa\u7968\u4eba\u8d26\u53f7[billerAcct]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getBillNo())) {
                throw new BusinessException("1001", "\u7968\u636e\u53f7\u7801[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getExpiryDate()) {
                throw new BusinessException("1001", "\u6c47\u7968\u5230\u671f\u65e5\u671f[expiryDate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getPayBank())) {
                throw new BusinessException("1001", "\u4ed8\u6b3e\u884c\u5168\u79f0[payBank]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getRecAcct())) {
                throw new BusinessException("1001", "\u6536\u6b3e\u4eba\u8d26\u53f7[recAcct]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getBillerName())) {
                throw new BusinessException("1001", "\u51fa\u7968\u4eba\u5168\u79f0[billerName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getRecName())) {
                throw new BusinessException("1001", "\u6536\u6b3e\u4eba\u5168\u79f0[recName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getRecOpenBank())) {
                throw new BusinessException("1001", "\u6536\u6b3e\u4eba\u5f00\u6237\u94f6\u884c[recOpenBank]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BillInfo billInfo = new BillInfo();
            billInfo.setRefNo(advanceReceive.getSeq());
            try {
                BeanUtils.copyProperties((Object)reqBO, (Object)billInfo);
            }
            catch (Exception e) {
                throw new BusinessException("1002", "\u7cfb\u7edf\u5f02\u5e38");
            }
            this.advanceReceiveMapper.insert(advanceReceive);
            this.billInfoMapper.insert(billInfo);
        }
        FscWfStartAtomReqBO req = new FscWfStartAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)req));
        req.setBillNo(advanceReceive.getSeq().toString());
        req.setBillType(WFBillType.HANDMADE_COLLECTION);
        req.setFinishEvtServiceId("handmadeCollectionWorkFlowFinshEventImpl");
        FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(req);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException("1002", "\u624b\u5de5\u5f55\u5165\u6536\u6b3e\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff0c\u53d1\u8d77\u5ba1\u6279\u5931\u8d25");
        }
        return new FscBaseRspBo();
    }
}

