/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.FscWfStartAtomService;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomRspBO;
import com.tydic.fsc.settle.busi.api.BusiCreateOutstockTotalService;
import com.tydic.fsc.settle.busi.api.bo.BusiCreateOutstockTotalReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCreateOutstockTotalRspBO;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.OutstockTotalMapper;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import com.tydic.fsc.settle.dao.po.OutstockTotal;
import com.tydic.fsc.settle.dao.vo.OutStockWithItemVO;
import com.tydic.fsc.settle.dao.vo.OutstockInfoVO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.OutstockInfoStatus;
import com.tydic.fsc.settle.enums.WFBillType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiCreateOutstockTotalServiceImpl
implements BusiCreateOutstockTotalService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCreateOutstockTotalServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OutstockTotalMapper outstockTotalMapper;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private EnumsService enumsService;

    public BusiCreateOutstockTotalRspBO createOutstockTotal(BusiCreateOutstockTotalReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u670d\u52a1\u5165\u53c2=" + reqBO);
        }
        BusiCreateOutstockTotalRspBO rspBO = new BusiCreateOutstockTotalRspBO();
        StringBuilder sb = new StringBuilder();
        String allFlag = reqBO.getAllFlag();
        String source = reqBO.getSource();
        Long companyId = reqBO.getCompanyId();
        List outstockNoList = reqBO.getOutstockNoList();
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        if ("1".equals(allFlag)) {
            if (!StringUtils.hasText((String)source)) {
                throw new BusinessException("1002", "\u6765\u6e90\u5fc5\u9009");
            }
            outstockInfoVO.setSource(source);
            outstockInfoVO.setCompanyOrg(companyId);
            outstockInfoVO.setStatus(OutstockInfoStatus.NO_SUM.getCode());
        } else {
            if (outstockNoList == null || outstockNoList.isEmpty()) {
                throw new BusinessException("1002", "\u8bf7\u52fe\u9009\u51fa\u5e93\u5355");
            }
            outstockInfoVO.setOutstockNos(outstockNoList);
        }
        List<OutStockWithItemVO> outstockInfos = this.outstockInfoMapper.selectOutStockWithItemCountByCondition(outstockInfoVO);
        if (outstockInfos.isEmpty()) {
            throw new BusinessException("1002", "\u6ca1\u6709\u672a\u6c47\u603b\u7684\u51fa\u5e93\u5355\uff0c\u6216\u8005\u51fa\u5e93\u5355\u6ca1\u6709\u6709\u6548\u7684\u53d1\u7968");
        }
        int limitCount = this.enumsService.queryOstGroupByOsdLimit();
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        int count = 0;
        int detailCounts = 0;
        String totalNo = this.billSNService.getSnAsString(BillType.MATERIAL_COLLECT);
        for (int i = 0; i < outstockInfos.size(); ++i) {
            OutStockWithItemVO outstockInfo = outstockInfos.get(i);
            String outstockNo = outstockInfos.get(i).getOutstockNo();
            if ("02".equals(outstockInfo.getStatus())) {
                logger.error("\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u5931\u8d25\uff1a\u51fa\u5e93\u5355\u53f7\u4e3a" + outstockNo + "\u7684\u51fa\u5e93\u5355\u5df2\u6c47\u603b");
                continue;
            }
            source = outstockInfo.getSource();
            int detailCount = outstockInfo.getCount();
            if (detailCounts + detailCount > limitCount && count > 0) {
                OutstockTotal outstockTotal = new OutstockTotal();
                outstockTotal.setTotalNo(totalNo);
                outstockTotal.setCreateDate(new Date());
                outstockTotal.setOrgId(reqBO.getCompanyId());
                outstockTotal.setUserId(reqBO.getUserId());
                outstockTotal.setSource(source);
                outstockTotal.setUntaxAmt(sumUntaxAmt);
                outstockTotal.setTaxAmt(sumTaxAmt);
                this.outstockTotalMapper.insertSelective(outstockTotal);
                sb.append(totalNo).append(",");
                FscWfStartAtomReqBO atomReqBO = new FscWfStartAtomReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
                atomReqBO.setBillType(WFBillType.OUTBOUND_COLLECTION);
                atomReqBO.setFinishEvtServiceId("outstockTotalWorkFlowFinishEventImpl");
                atomReqBO.setBillNo(totalNo);
                FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException("1002", "\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u670d\u52a1\u5931\u8d25\uff0c\u53d1\u8d77\u5ba1\u6279\u5931\u8d25");
                }
                sumUntaxAmt = BigDecimal.ZERO;
                sumTaxAmt = BigDecimal.ZERO;
                count = 0;
                detailCounts = 0;
                totalNo = this.billSNService.getSnAsString(BillType.MATERIAL_COLLECT);
            }
            sumUntaxAmt = sumUntaxAmt.add(outstockInfo.getUntaxAmt());
            sumTaxAmt = sumTaxAmt.add(outstockInfo.getTaxAmt());
            ++count;
            detailCounts += detailCount;
            OutstockInfo outstockInfo2 = new OutstockInfo();
            outstockInfo2.setOutstockNo(outstockInfo.getOutstockNo());
            outstockInfo2.setTotalNo(totalNo);
            outstockInfo2.setStatus("02");
            this.outstockInfoMapper.updateByPrimaryKeySelective(outstockInfo2);
            if (i != outstockInfos.size() - 1) continue;
            OutstockTotal outstockTotal = new OutstockTotal();
            outstockTotal.setTotalNo(totalNo);
            outstockTotal.setCreateDate(new Date());
            outstockTotal.setOrgId(reqBO.getCompanyId());
            outstockTotal.setUserId(reqBO.getUserId());
            outstockTotal.setSource(source);
            outstockTotal.setUntaxAmt(sumUntaxAmt);
            outstockTotal.setTaxAmt(sumTaxAmt);
            this.outstockTotalMapper.insertSelective(outstockTotal);
            sb.append(totalNo).append(",");
            FscWfStartAtomReqBO atomReqBO = new FscWfStartAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
            atomReqBO.setBillType(WFBillType.OUTBOUND_COLLECTION);
            atomReqBO.setFinishEvtServiceId("outstockTotalWorkFlowFinishEventImpl");
            atomReqBO.setBillNo(totalNo);
            FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(atomReqBO);
            if ("0000".equals(atomRspBO.getRespCode())) continue;
            throw new BusinessException("1002", "\u751f\u6210\u51fa\u5e93\u6c47\u603b\u5355\u670d\u52a1\u5931\u8d25\uff0c\u53d1\u8d77\u5ba1\u6279\u5931\u8d25");
        }
        if (sb.length() <= 0) {
            throw new BusinessException("1002", "\u6ca1\u6709\u672a\u6c47\u603b\u7684\u51fa\u5e93\u5355");
        }
        sb.setLength(sb.length() - 1);
        rspBO.setTotalNo(sb.toString());
        return rspBO;
    }
}

