/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.PayInvoiceService;
import com.tydic.fsc.settle.busi.api.BusiGetInvoiceService;
import com.tydic.fsc.settle.busi.api.BusiUpdateNotificationExcepService;
import com.tydic.fsc.settle.busi.api.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.fsc.settle.busi.api.vo.BusiGetInvoiceResultVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.enums.InvoiceMailStatus;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.supplier.BusiGetInvoiceDataService;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataRspVO;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataServiceReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class BusiGetInvoiceServiceImpl
implements BusiGetInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiGetInvoiceServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private PayInvoiceService payInvoiceService;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    private boolean isBusy = false;

    public boolean isBusy() {
        return this.isBusy;
    }

    public BusiGetInvoiceServiceRspBO getInvoice(BusiGetInvoiceServiceReqBO busiGetInvoiceServiceReqBO) {
        this.isBusy = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiGetInvoiceServiceReqBO.toString());
        }
        try {
            BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.process();
            return busiGetInvoiceServiceRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiGetInvoiceServiceRspBO process() {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (BillNotificationInfo info : invoiceList) {
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
        }
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealData(invoiceDataList, rspBO);
    }

    private BusiGetInvoiceServiceRspBO dealData(List<BusiGetInvoiceDataRspVO> invoiceDataList, BusiGetInvoiceServiceRspBO rspBO) {
        for (BusiGetInvoiceDataRspVO invoiceData : invoiceDataList) {
            BusiGetInvoiceResultVO resultVO = new BusiGetInvoiceResultVO();
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:" + invoiceData.getNotificationNo() + "," + invoiceData.getResultCode() + "," + invoiceData.getResultMsg() + ",sup=" + invoiceData.getSupplierNo() + "(" + invoiceData.getSupplierCode() + ")");
            BeanUtils.copyProperties((Object)invoiceData, (Object)resultVO);
            rspBO.getResultList().add(resultVO);
            PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
            BeanUtils.copyProperties((Object)invoiceData, (Object)invoiceInfo);
            if (StringUtils.hasText((String)invoiceData.getInvoiceNo())) {
                invoiceInfo.setInvoiceStatus("01");
                invoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
                try {
                    this.payInvoiceService.createInvoice(invoiceInfo);
                }
                catch (Exception e) {
                    LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                }
                continue;
            }
            this.busiUpdateNotificationExcepService.updateNotificationException(invoiceData.getResultMsg(), invoiceData.getNotificationNo());
        }
        return rspBO;
    }
}

