/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.ElectronicInvoiceAtomService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiPlatfUseFeeBatchInvoiceApplyService;
import com.tydic.fsc.settle.busi.api.BusiQueryElectronicInvoiceMoreTicket;
import com.tydic.fsc.settle.busi.api.bo.BusiPlatfUseFeeBatchInvoiceApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryElectronicInvoiceMoreTicketReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryElectronicInvoiceMoreTicketRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.vo.PayInvoiceVO;
import com.tydic.fsc.settle.enums.ApplyType;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.RedBlue;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import com.tydic.fsc.settle.vo.SupplierBillVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class BusiPlatfUseFeeBatchInvoiceApplyServiceImpl
implements BusiPlatfUseFeeBatchInvoiceApplyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPlatfUseFeeBatchInvoiceApplyServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired(required=false)
    private BusiQueryElectronicInvoiceMoreTicket busiQueryElectronicInvoiceMoreTicket;
    @Autowired
    private ElectronicInvoiceAtomService electronicInvoiceAtomService;

    public FscBaseRspBo processBatchInvoiceApply(BusiPlatfUseFeeBatchInvoiceApplyReqBO reqBO) {
        List payOrderNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e73\u53f0\u4f7f\u7528\u8d39\u6279\u91cf\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((payOrderNos = reqBO.getPayOrderNos()) == null || payOrderNos.isEmpty()) {
            throw new BusinessException("1001", "\u5165\u53c2\u7f34\u8d39\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<InquiryPayOrder> inquiryPayOrderList = this.inquiryPayOrderMapper.selectByPayOrderNos(payOrderNos);
        if (null == inquiryPayOrderList || inquiryPayOrderList.isEmpty()) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u672a\u67e5\u5230\u6240\u52fe\u9009\u8ba2\u5355\u7684\u4fe1\u606f");
        }
        for (InquiryPayOrder inquiryPayOrder : inquiryPayOrderList) {
            if (!OrderStatus.NO_APPLY.getCode().equals(inquiryPayOrder.getOrderStatus())) {
                throw new BusinessException("1002", "\u5f00\u7968\u72b6\u6001\u4e3a" + this.enumsService.getDescr(OrderStatus.NO_APPLY) + "\u7684\u8ba2\u5355\u624d\u80fd\u7533\u8bf7\u5f00\u7968");
            }
            if (InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.REC_CONFIRMED.getCode().equals(inquiryPayOrder.getPaymentStatus())) continue;
            throw new BusinessException("1002", "\u6536\u6b3e\u72b6\u6001\u4e3a" + this.enumsService.getDescr(InquiryPaymentStatus.OFFLINE_PAID) + "\u3001" + this.enumsService.getDescr(InquiryPaymentStatus.CHECK_SUCCEED) + "\u3001" + this.enumsService.getDescr(InquiryPaymentStatus.REC_CONFIRMED) + "\u7684\u8ba2\u5355\u624d\u80fd\u7533\u8bf7\u5f00\u7968");
        }
        BusiQueryElectronicInvoiceMoreTicketReqBO ticketReqBO = new BusiQueryElectronicInvoiceMoreTicketReqBO();
        BusiQueryElectronicInvoiceMoreTicketRspBO ticketRspBO = this.busiQueryElectronicInvoiceMoreTicket.processQueryMoreTicket(ticketReqBO);
        int ticketCountVal = Integer.parseInt(ticketRspBO.getTicketCountVal());
        if (ticketCountVal < payOrderNos.size()) {
            throw new BusinessException("1002", "\u7535\u5b50\u53d1\u7968\u4f59\u7968\u4e0d\u8db3,\u4f59\u7968\u6570=" + ticketCountVal);
        }
        List<String> applyNos = null;
        DataSourceTransactionManager transactionManager = (DataSourceTransactionManager)SpringApplicationContext.getBean("transactionManagerUser");
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        try {
            applyNos = this.addBillApplyInfo(reqBO, inquiryPayOrderList);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("1002", e.getMessage());
        }
        this.electronicInvoiceAtomService.applyBlueInvoice(applyNos);
        Map<Long, List<String>> payOrderNoMap = this.groupBySupplierId(inquiryPayOrderList);
        int existCount = payOrderNoMap.size();
        for (Map.Entry<Long, List<String>> entry : payOrderNoMap.entrySet()) {
            Long eachSupId = entry.getKey();
            List<SupplierBillVO> supplierBillVOs = this.qryBillBySupplierId(eachSupId);
            if (!CollectionUtils.isEmpty(supplierBillVOs)) continue;
            --existCount;
        }
        FscBaseRspBo rspBO = new FscBaseRspBo();
        if (existCount == payOrderNoMap.size()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else if (existCount < payOrderNoMap.size() && existCount > 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u90e8\u5206\u4f9b\u5e94\u5546\u672a\u7ef4\u62a4\u53d1\u7968\u62ac\u5934");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5747\u672a\u7ef4\u62a4\u53d1\u7968\u62ac\u5934");
        }
        return rspBO;
    }

    private Map<Long, List<String>> groupBySupplierId(List<InquiryPayOrder> inquiryPayOrderList) {
        HashMap<Long, List<String>> payOrderNoMap = new HashMap<Long, List<String>>();
        for (InquiryPayOrder inquiryPayOrder : inquiryPayOrderList) {
            if (payOrderNoMap.containsKey(inquiryPayOrder.getSupplierId())) {
                ((List)payOrderNoMap.get(inquiryPayOrder.getSupplierId())).add(inquiryPayOrder.getInquiryNo());
                continue;
            }
            LinkedList<String> newPayOrderNoList = new LinkedList<String>();
            newPayOrderNoList.add(inquiryPayOrder.getInquiryNo());
            payOrderNoMap.put(inquiryPayOrder.getSupplierId(), newPayOrderNoList);
        }
        return payOrderNoMap;
    }

    private List<String> addBillApplyInfo(BusiPlatfUseFeeBatchInvoiceApplyReqBO reqBO, List<InquiryPayOrder> inquiryPayOrderList) {
        ArrayList<String> applyNos = new ArrayList<String>();
        for (InquiryPayOrder order : inquiryPayOrderList) {
            List<SupplierBillVO> supplierBillVOs = this.qryBillBySupplierId(order.getSupplierId());
            if (CollectionUtils.isEmpty(supplierBillVOs)) continue;
            String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
            BigDecimal amt = BigDecimal.ZERO;
            ArrayList<String> eachPayOrderNos = new ArrayList<String>();
            eachPayOrderNos.add(order.getPayOrderNo());
            List<InquiryPayOrder> list = this.inquiryPayOrderMapper.selectByPayOrderNos(eachPayOrderNos);
            if (null == list || list.isEmpty()) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u672a\u67e5\u5230\u6240\u52fe\u9009\u8ba2\u5355");
            }
            String payFeeType = list.get(0).getPayFeeType();
            HashSet<Long> operUnitSet = new HashSet<Long>();
            for (InquiryPayOrder inquiryPayOrder : list) {
                if (!OrderStatus.NO_APPLY.getCode().equals(inquiryPayOrder.getOrderStatus())) {
                    throw new BusinessException("1002", "\u8bf7\u52fe\u9009\u672a\u63d0\u4ea4\u7684\u8ba2\u5355");
                }
                amt = amt.add(inquiryPayOrder.getPayMoney());
                operUnitSet.add(inquiryPayOrder.getOperUnitNo());
            }
            if (1 != operUnitSet.size()) {
                throw new BusinessException("1002", "\u4e0d\u652f\u6301\u4e0d\u540c\u4e13\u4e1a\u516c\u53f8\u4fe1\u606f\u7684\u8ba2\u5355\u5408\u5e76\u5f00\u7968");
            }
            Long supplierNo = list.get(0).getSupplierId();
            Long operUnitNo = list.get(0).getOperUnitNo();
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
            billApplyInfo.setSupplierNo(supplierNo);
            billApplyInfo.setOperUnitNo(operUnitNo);
            billApplyInfo.setOperUnitName(this.organizationInfoService.queryOrgName(operUnitNo));
            billApplyInfo.setSupplierName(this.organizationInfoService.querySupplierName(supplierNo));
            billApplyInfo.setPayFeeType(payFeeType);
            SupplierBillVO firstSupplierBill = supplierBillVOs.get(0);
            billApplyInfo.setInvoiceType(InvoiceType.NORMAL.getCode().toString());
            billApplyInfo.setInvoceName(firstSupplierBill.getCompName());
            billApplyInfo.setTaxNo(firstSupplierBill.getNum());
            billApplyInfo.setAddr(firstSupplierBill.getAddress());
            billApplyInfo.setPhone(firstSupplierBill.getTel());
            billApplyInfo.setBankName(firstSupplierBill.getBankName());
            billApplyInfo.setBankAcctNo(firstSupplierBill.getBankAcct());
            billApplyInfo.setReceiveInvoicePhone(this.enumsService.queryReceiveInvoicePhone());
            billApplyInfo.setReceiveInvoiceEmail(this.enumsService.queryReceiveInvoiceEmail());
            billApplyInfo.setApplyNo(applyNo);
            billApplyInfo.setApplyDate(new Date());
            billApplyInfo.setAmt(amt);
            billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo.setUserId(reqBO.getUserId());
            billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
            billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.ELECTRONIC_INVOICE.getCode());
            billApplyInfo.setRedBlue(RedBlue.BLUE.getCode());
            this.billApplyInfoMapper.insert(billApplyInfo);
            PayInvoiceVO payInvoiceVO = new PayInvoiceVO();
            payInvoiceVO.setPayOrderNos(eachPayOrderNos);
            payInvoiceVO.setApplyNo(applyNo);
            payInvoiceVO.setOrderStatus(OrderStatus.APPLIED.getCode());
            this.inquiryPayOrderMapper.updateForBill(payInvoiceVO);
            applyNos.add(applyNo);
        }
        return applyNos;
    }

    private List<SupplierBillVO> qryBillBySupplierId(Long eachSupId) {
        return null;
    }
}

